/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Address;

public final class BasicAddress
implements Address {
    static final Address None = new BasicAddress(0L, "None");
    private final long id;
    private final String name;

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long idSequence() {
        return this.id();
    }

    @Override
    public String idSequenceString() {
        return this.idString();
    }

    @Override
    public String idString() {
        return String.valueOf(this.id);
    }

    @Override
    public <T> T idTyped() {
        return (T)this.idString();
    }

    @Override
    public final String name() {
        return this.name == null ? Long.toString(this.id) : this.name;
    }

    @Override
    public boolean isDistributable() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != BasicAddress.class) {
            return false;
        }
        return this.id == ((BasicAddress)other).id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "Address[id=" + this.id + ", name=" + (this.name == null ? "(none)" : this.name) + "]";
    }

    @Override
    public int compareTo(Address other) {
        return Long.compare(this.id, ((BasicAddress)other).id);
    }

    BasicAddress(long reservedId) {
        this(reservedId, null);
    }

    BasicAddress(long reservedId, String name) {
        this(reservedId, name, false);
    }

    BasicAddress(long reservedId, String name, boolean prefixName) {
        this.id = reservedId;
        this.name = name == null ? null : (prefixName ? name + this.id : name);
    }
}

