/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.DeadLetter;
import io.vlingo.actors.DeadLetters;
import io.vlingo.actors.DeadLettersListener;
import java.util.ArrayList;
import java.util.List;

public class DeadLettersActor
extends Actor
implements DeadLetters {
    private final List<DeadLettersListener> listeners = new ArrayList<DeadLettersListener>();

    @Override
    public void failedDelivery(DeadLetter deadLetter) {
        this.logger().debug(deadLetter.toString());
        for (DeadLettersListener listener : this.listeners) {
            try {
                listener.handle(deadLetter);
            }
            catch (Throwable t) {
                this.logger().warn("DeadLetters listener failed to handle: " + deadLetter, t);
            }
        }
    }

    @Override
    public void registerListener(DeadLettersListener listener) {
        this.listeners.add(listener);
    }

    @Override
    protected void beforeStart() {
        super.beforeStart();
        this.stage().world().setDeadLetters(this.selfAs(DeadLetters.class));
    }

    @Override
    protected void afterStop() {
        this.stage().world().setDeadLetters(null);
        super.afterStop();
    }
}

