/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Configuration;
import io.vlingo.actors.plugin.PluginConfiguration;
import io.vlingo.actors.plugin.PluginProperties;

public class DirectoryEvictionConfiguration
implements PluginConfiguration {
    public static final long DEFAULT_LRU_MILLIS = 600000L;
    public static final float DEFAULT_FILL_RATIO_HIGH = 0.8f;
    private String name = "directoryEviction";
    private boolean enabled;
    private long lruThresholdMillis;
    private float fillRatioHigh;

    public static DirectoryEvictionConfiguration define() {
        return new DirectoryEvictionConfiguration();
    }

    public DirectoryEvictionConfiguration() {
        this(false, 600000L, 0.8f);
    }

    public DirectoryEvictionConfiguration(boolean enabled, long lruThresholdMillis, float fillRatioHigh) {
        this.enabled = enabled;
        this.lruThresholdMillis = lruThresholdMillis;
        this.fillRatioHigh = fillRatioHigh;
    }

    public DirectoryEvictionConfiguration enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DirectoryEvictionConfiguration lruThresholdMillis(long millis) {
        this.lruThresholdMillis = millis;
        return this;
    }

    public long lruThresholdMillis() {
        return this.lruThresholdMillis;
    }

    public DirectoryEvictionConfiguration fillRatioHigh(float ratio) {
        this.fillRatioHigh = ratio;
        return this;
    }

    public float fillRatioHigh() {
        return this.fillRatioHigh;
    }

    @Override
    public void build(Configuration configuration) {
        configuration.with(this.lruThresholdMillis(600000L).fillRatioHigh(0.8f));
    }

    @Override
    public void buildWith(Configuration configuration, PluginProperties properties) {
        this.name = properties.name;
        this.lruThresholdMillis = properties.getLong("lruThresholdMillis", 600000L);
        this.fillRatioHigh = properties.getFloat("fillRatioHigh", Float.valueOf(0.8f)).floatValue();
        configuration.with(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("DirectoryEvictionConfiguration(name='%s', enabled='%b', lruThresholdMillis='%s', fillRatioHigh='%.2f')", this.name, this.enabled, this.lruThresholdMillis, Float.valueOf(this.fillRatioHigh));
    }
}

