/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.Definition;
import io.vlingo.actors.FailureMark;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.ResultReturns;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Supervisor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pcollections.PVector;
import org.pcollections.TreePVector;

public class Environment {
    final Address address;
    PVector<Actor> children;
    Address completesEventuallyAddress;
    final Definition definition;
    final FailureMark failureMark;
    final Logger logger;
    final Mailbox mailbox;
    final Supervisor maybeSupervisor;
    final Actor parent;
    final Map<String, Object> proxyCache;
    final Stage stage;
    private final AtomicBoolean secured;
    private final AtomicBoolean stopped;
    private Class<?>[] stowageOverrides;

    protected Environment(Stage stage, Address address, Definition definition, Actor parent, Mailbox mailbox, Supervisor maybeSupervisor, Logger logger) {
        assert (stage != null);
        this.stage = stage;
        assert (address != null);
        this.address = address;
        assert (definition != null);
        this.definition = definition;
        if (address.id() != Long.MAX_VALUE) assert (parent != null);
        this.parent = parent;
        assert (mailbox != null);
        this.mailbox = mailbox;
        this.maybeSupervisor = maybeSupervisor;
        this.failureMark = new FailureMark();
        this.logger = logger;
        this.children = TreePVector.empty();
        this.proxyCache = new HashMap<String, Object>(1);
        this.stowageOverrides = null;
        this.secured = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }

    void addChild(Actor child) {
        this.children = this.children.plus((Object)child);
    }

    CompletesEventually completesEventually(ResultReturns result) {
        if (this.completesEventuallyAddress == null) {
            CompletesEventually completesEventually = this.stage.world().completesFor(result.clientReturns());
            this.completesEventuallyAddress = completesEventually.address();
            return completesEventually;
        }
        return this.stage.world().completesFor(this.completesEventuallyAddress, result.clientReturns());
    }

    <T> void cacheProxy(T proxy) {
        this.proxyCache.put(proxy.getClass().getName(), proxy);
    }

    <T> T lookUpProxy(Class<T> protocol) {
        return (T)this.proxyCache.get(protocol.getName());
    }

    boolean isSecured() {
        return this.secured.get();
    }

    void setSecured() {
        this.secured.set(true);
    }

    boolean isStopped() {
        return this.stopped.get();
    }

    void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.stopChildren();
            this.mailbox.close();
        }
    }

    boolean isStowageOverride(Class<?> protocol) {
        if (this.stowageOverrides != null) {
            for (Class<?> override : this.stowageOverrides) {
                if (override != protocol) continue;
                return true;
            }
        }
        return false;
    }

    void stowageOverrides(Class<?> ... overrides) {
        this.stowageOverrides = overrides;
    }

    private void stopChildren() {
        this.children.forEach(child -> child.stop());
        this.children = TreePVector.empty();
    }
}

