/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InvalidProtocolException
extends IllegalStateException {
    private static final long serialVersionUID = 1L;
    private final String protocolName;
    private final List<Failure> failures;

    public InvalidProtocolException(String protocolName, List<Failure> failures) {
        super(InvalidProtocolException.toReadableMessage(protocolName, failures));
        this.protocolName = protocolName;
        this.failures = failures;
    }

    @Override
    public String toString() {
        return "Protocol '" + this.protocolName + "'  with failures " + this.failures;
    }

    private static String toReadableMessage(String protocolName, List<Failure> failures) {
        Stream<String> failureMessages = failures.stream().map(Failure::toString).map(msg -> "\t" + msg);
        return Stream.concat(Stream.of("For protocol " + protocolName), failureMessages).collect(Collectors.joining("\n"));
    }

    public static class Failure {
        public final String method;
        public final String cause;

        public Failure(String method, String cause) {
            this.method = method;
            this.cause = cause;
        }

        public String toString() {
            return "In method `" + this.method.trim() + "`: \n\t\t" + this.cause;
        }
    }
}

