/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.logging.LogEvent;
import io.vlingo.actors.plugin.logging.noop.NoOpLogger;
import io.vlingo.actors.plugin.logging.slf4j.Slf4jLoggerPlugin;

public interface Logger {
    public static Logger noOpLogger() {
        return new NoOpLogger();
    }

    public static Logger basicLogger() {
        return Slf4jLoggerPlugin.basicInstance();
    }

    public String name();

    public void close();

    public boolean isEnabled();

    default public void trace(String message) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).build();
        this.trace(logEvent);
    }

    default public void trace(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withArgs(args).build();
        this.trace(logEvent);
    }

    default public void trace(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withThrowable(throwable).build();
        this.trace(logEvent);
    }

    default public void debug(String message) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).build();
        this.debug(logEvent);
    }

    default public void debug(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withArgs(args).build();
        this.debug(logEvent);
    }

    default public void debug(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withThrowable(throwable).build();
        this.debug(logEvent);
    }

    default public void info(String message) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).build();
        this.info(logEvent);
    }

    default public void info(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withArgs(args).build();
        this.info(logEvent);
    }

    default public void info(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withThrowable(throwable).build();
        this.info(logEvent);
    }

    default public void warn(String message) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).build();
        this.warn(logEvent);
    }

    default public void warn(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withArgs(args).build();
        this.warn(logEvent);
    }

    default public void warn(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withThrowable(throwable).build();
        this.warn(logEvent);
    }

    default public void error(String message) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).build();
        this.error(logEvent);
    }

    default public void error(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withArgs(args).build();
        this.error(logEvent);
    }

    default public void error(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(Logger.class, message).withThrowable(throwable).build();
        this.error(logEvent);
    }

    public void trace(LogEvent var1);

    public void debug(LogEvent var1);

    public void info(LogEvent var1);

    public void warn(LogEvent var1);

    public void error(LogEvent var1);
}

