/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.InvalidProtocolException;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Properties;
import io.vlingo.actors.SafeProxyGenerable;
import io.vlingo.common.Tuple2;
import io.vlingo.common.compiler.DynaFile;
import io.vlingo.common.compiler.DynaNaming;
import io.vlingo.common.compiler.DynaType;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProxyGenerator
implements AutoCloseable {
    private static final String GENERICS_WILDCARD = "?";
    private final Logger logger;
    private final boolean persist;
    private final File rootOfGenerated;
    private final DynaType type;
    private final URLClassLoader urlClassLoader;

    public static ProxyGenerator forClasspath(ClassLoader classLoader, List<File> classPath, File destinationDirectory, DynaType type, boolean persist, Logger logger) throws Exception {
        return new ProxyGenerator(classLoader, classPath, destinationDirectory, type, persist, logger);
    }

    public static ProxyGenerator forMain(ClassLoader classLoader, boolean persist, Logger logger) throws Exception {
        DynaType type = DynaType.Main;
        List<File> classPath = Collections.singletonList(new File(Properties.properties.getProperty("proxy.generated.classes.main", "target/classes/")));
        File rootOfGenerated = ProxyGenerator.rootOfGeneratedSources(type);
        return new ProxyGenerator(classLoader, classPath, rootOfGenerated, type, persist, logger);
    }

    public static ProxyGenerator forTest(ClassLoader classLoader, boolean persist, Logger logger) throws Exception {
        DynaType type = DynaType.Test;
        List<File> classPath = Collections.singletonList(new File(Properties.properties.getProperty("proxy.generated.classes.test", "target/test-classes/")));
        File rootOfGenerated = ProxyGenerator.rootOfGeneratedSources(type);
        return new ProxyGenerator(classLoader, classPath, rootOfGenerated, type, persist, logger);
    }

    @Override
    public void close() throws Exception {
        this.urlClassLoader.close();
    }

    public Result generateFor(String actorProtocol) {
        this.logger.debug("vlingo/actors: Generating proxy for " + (this.type == DynaType.Main ? "main" : "test") + ": " + actorProtocol);
        try {
            Class<?> protocolInterface = this.readProtocolInterface(actorProtocol);
            String proxyClassSource = this.proxyClassSource(protocolInterface);
            String fullyQualifiedClassname = DynaNaming.fullyQualifiedClassnameFor(protocolInterface, (String)"__Proxy");
            String relativeTargetFile = DynaFile.toFullPath((String)fullyQualifiedClassname);
            File sourceFile = this.persist ? this.persistProxyClassSource(actorProtocol, relativeTargetFile, proxyClassSource) : new File(relativeTargetFile);
            return new Result(fullyQualifiedClassname, DynaNaming.classnameFor(protocolInterface, (String)"__Proxy"), proxyClassSource, sourceFile);
        }
        catch (InvalidProtocolException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot generate proxy class for: " + actorProtocol, e);
        }
    }

    DynaType type() {
        return this.type;
    }

    URLClassLoader urlClassLoader() {
        return this.urlClassLoader;
    }

    private ProxyGenerator(ClassLoader classLoader, List<File> rootOfClasses, File rootOfGenerated, DynaType type, boolean persist, Logger logger) throws Exception {
        this.rootOfGenerated = rootOfGenerated;
        this.type = type;
        this.persist = persist;
        this.logger = logger;
        this.urlClassLoader = this.initializeClassLoader(classLoader, rootOfClasses);
    }

    private String classStatement(Class<?> protocolInterface) {
        return GenericParser.implementsInterfaceTemplateOf(DynaNaming.classnameFor(protocolInterface, (String)"__Proxy"), protocolInterface) + " {\n";
    }

    private String constructor(Class<?> protocolInterface) {
        StringBuilder builder = new StringBuilder();
        String signature = MessageFormat.format("  public {0}(final Actor actor, final Mailbox mailbox)", DynaNaming.classnameFor(protocolInterface, (String)"__Proxy"));
        builder.append(signature).append("{\n").append("    super(").append(protocolInterface.getCanonicalName()).append(".class").append(", SerializationProxy.from(actor.definition()), actor.address());").append("\n").append("    this.actor = actor;").append("\n").append("    this.mailbox = mailbox;").append("\n").append("  }\n");
        return builder.toString();
    }

    private String emptyConstructor(Class<?> protocolInterface) {
        StringBuilder builder = new StringBuilder();
        String signature = MessageFormat.format("  public {0}()", DynaNaming.classnameFor(protocolInterface, (String)"__Proxy"));
        builder.append(signature).append("{\n").append("    super();").append("\n").append("    this.actor = null;").append("\n").append("    this.mailbox = null;").append("\n").append("  }\n");
        return builder.toString();
    }

    private String importStatements(Class<?> protocolInterface) {
        StringBuilder builder = new StringBuilder();
        builder.append("import io.vlingo.actors.Actor;").append("\n").append("import io.vlingo.actors.Definition.SerializationProxy;").append("\n").append("import io.vlingo.actors.ActorProxyBase;").append("\n").append("import io.vlingo.actors.DeadLetter;").append("\n").append("import io.vlingo.actors.LocalMessage;").append("\n").append("import io.vlingo.actors.Mailbox;").append("\n").append("import io.vlingo.actors.Returns;").append("\n").append("import io.vlingo.common.Completes;").append("\n").append("import io.vlingo.common.SerializableConsumer;").append("\n").append("import ").append(protocolInterface.getCanonicalName()).append(";\n");
        GenericParser.dependenciesOf(protocolInterface).filter(d -> !d.startsWith(GENERICS_WILDCARD)).filter(t -> !t.contains("[]")).map(type1 -> "import " + type1 + ";\n").collect(Collectors.toSet()).forEach(builder::append);
        return builder.toString();
    }

    private URLClassLoader initializeClassLoader(ClassLoader classLoader, List<File> targetClassPath) throws MalformedURLException {
        URL[] classPathURLs = new URL[targetClassPath.size()];
        for (int idx = 0; idx < targetClassPath.size(); ++idx) {
            classPathURLs[idx] = targetClassPath.get(idx).toURI().toURL();
        }
        URLClassLoader urlClassLoader = new URLClassLoader(classPathURLs, classLoader);
        return urlClassLoader;
    }

    private String instanceVariables(Class<?> protocolInterface) {
        StringBuilder builder = new StringBuilder();
        builder.append("  private final Actor actor;").append("\n").append("  private final Mailbox mailbox;").append("\n");
        return builder.toString();
    }

    private Tuple2<InvalidProtocolException.Failure, String> methodDefinition(Class<?> protocolInterface, Method method, int count) {
        String returnStatement;
        StringBuilder builder = new StringBuilder();
        String genericTemplate = GenericParser.genericTemplateOf(method);
        String parameterTemplate = GenericParser.parametersTemplateOf(method);
        String signatureReturnType = GenericParser.returnTypeOf(method);
        boolean isACompletes = signatureReturnType.startsWith("io.vlingo.common.Completes");
        boolean isAFuture = signatureReturnType.startsWith("java.util.concurrent.Future") || signatureReturnType.startsWith("java.util.concurrent.CompletableFuture");
        boolean hasResult = isACompletes || isAFuture;
        String methodSignature = MessageFormat.format("  public {0}{1} {2}{3}", genericTemplate, signatureReturnType, method.getName(), parameterTemplate);
        String throwsExceptions = this.throwsExceptions(method);
        String ifNotStopped = "    if (!actor.isStopped()) {";
        String bindSelfStatement = MessageFormat.format("      ActorProxyBase<{0}> self = this;", protocolInterface.getSimpleName());
        String consumerStatement = MessageFormat.format("      final SerializableConsumer<{0}> consumer = (actor) -> actor.{1}{2};", protocolInterface.getSimpleName(), method.getName(), this.parameterNamesFor(method));
        String completesStatement = isACompletes ? MessageFormat.format("      final {0} returnValue = Completes.using(actor.scheduler());\n", signatureReturnType) : "";
        String futureStatement = isAFuture ? MessageFormat.format("      final {0} returnValue = new java.util.concurrent.CompletableFuture<>();\n", signatureReturnType) : "";
        String representationName = MessageFormat.format("{0}Representation{1}", method.getName(), count);
        String preallocatedMailbox = MessageFormat.format("      if (mailbox.isPreallocated()) '{' mailbox.send(actor, {0}.class, {1}, {2}{3}); '}'", protocolInterface.getSimpleName(), "consumer", hasResult ? "Returns.value(returnValue), " : "null, ", representationName);
        String mailboxSendStatement = MessageFormat.format("      else '{' mailbox.send(new LocalMessage<{0}>(actor, {0}.class, {1}, {2}{3})); '}'", protocolInterface.getSimpleName(), "consumer", hasResult ? "Returns.value(returnValue), " : "", representationName);
        String completesReturnStatement = hasResult ? "      return returnValue;\n" : "";
        String elseDead = MessageFormat.format("      actor.deadLetters().failedDelivery(new DeadLetter(actor, {0}));", representationName);
        String returnValue = this.returnValue(method.getReturnType());
        String string = returnStatement = returnValue.isEmpty() ? "" : MessageFormat.format("    return {0};\n", returnValue);
        if (!(isACompletes || returnValue.isEmpty() || genericTemplate.contains(signatureReturnType) || genericTemplate.contains(parameterTemplate) || this.isSafeGenerable(protocolInterface) || isAFuture)) {
            return Tuple2.from((Object)new InvalidProtocolException.Failure(methodSignature, "method return type should be either `void`, `Completes<T>`, `Future<T>` or `CompletableFuture<T>`. The found return type is `" + signatureReturnType + "`. Consider wrapping it in `Completes<T>`, like `Completes<" + this.validForCompletes(signatureReturnType) + ">`."), null);
        }
        builder.append(methodSignature).append(throwsExceptions).append(" {\n").append("    if (!actor.isStopped()) {").append("\n").append(bindSelfStatement).append("\n").append(consumerStatement).append("\n").append(completesStatement).append(futureStatement).append(preallocatedMailbox).append("\n").append(mailboxSendStatement).append("\n").append(completesReturnStatement).append("    } else {\n").append(elseDead).append("\n").append("    }\n").append(returnStatement).append("  }\n");
        return Tuple2.from(null, (Object)builder.toString());
    }

    private Tuple2<List<InvalidProtocolException.Failure>, String> methodDefinitions(Class<?> protocolInterface, Method[] methods) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> failures = new ArrayList<Object>();
        int count = 0;
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            Tuple2<InvalidProtocolException.Failure, String> result = this.methodDefinition(protocolInterface, method, ++count);
            if (result._1 == null) {
                builder.append((String)result._2);
                continue;
            }
            failures.add(result._1);
        }
        if (failures.isEmpty()) {
            return Tuple2.from(null, (Object)builder.toString());
        }
        return Tuple2.from(failures, null);
    }

    private String packageStatement(Class<?> protocolInterface) {
        return MessageFormat.format("package {0};", protocolInterface.getPackage().getName());
    }

    private String parameterNamesFor(Method method) {
        return Arrays.stream(method.getParameters()).map(p -> "ActorProxyBase.thunk(self, (Actor)actor, " + p.getName() + ")").collect(Collectors.joining(", ", "(", ")"));
    }

    private String parameterTypesFor(Method method) {
        Parameter[] parameters;
        StringBuilder builder = new StringBuilder();
        String separator = ", ";
        int parameterIndex = 0;
        for (Parameter parameter : parameters = method.getParameters()) {
            Type type = parameter.getParameterizedType();
            builder.append(type.getTypeName().replace('$', '.'));
            if (++parameterIndex >= parameters.length) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    private File persistProxyClassSource(String actorProtocol, String relativePathToClass, String proxyClassSource) throws Exception {
        String pathToGeneratedSource = DynaFile.toPackagePath((String)actorProtocol);
        new File(this.rootOfGenerated, pathToGeneratedSource).mkdirs();
        File pathToSource = new File(this.rootOfGenerated, relativePathToClass + ".java");
        return DynaFile.persistDynaClassSource((String)pathToSource.getCanonicalPath(), (String)proxyClassSource);
    }

    private String proxyClassSource(Class<?> protocolInterface) {
        Method[] methods = protocolInterface.getMethods();
        StringBuilder builder = new StringBuilder();
        Tuple2<List<InvalidProtocolException.Failure>, String> methodDefs = this.methodDefinitions(protocolInterface, methods);
        if (methodDefs._1 != null) {
            throw new InvalidProtocolException(protocolInterface.getCanonicalName(), (List)methodDefs._1);
        }
        builder.append(this.packageStatement(protocolInterface)).append("\n\n").append(this.importStatements(protocolInterface)).append("\n").append(this.classStatement(protocolInterface)).append("\n").append(this.representationStatements(methods)).append("\n").append(this.instanceVariables(protocolInterface)).append("\n").append(this.constructor(protocolInterface)).append("\n").append(this.emptyConstructor(protocolInterface)).append("\n").append((String)methodDefs._2).append("}").append("\n");
        return builder.toString();
    }

    private Class<?> readProtocolInterface(String actorProtocol) throws Exception {
        return this.urlClassLoader.loadClass(actorProtocol);
    }

    private String representationStatements(Method[] methods) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            String statement = MessageFormat.format("  private static final String {0}Representation{1} = \"{0}({2})\";\n", method.getName(), ++count, this.parameterTypesFor(method));
            builder.append(statement);
        }
        return builder.toString();
    }

    private String returnValue(Class<?> returnType) {
        if (returnType.getName().equals("void")) {
            return "";
        }
        if (returnType.isPrimitive()) {
            switch (returnType.getName()) {
                case "boolean": {
                    return "false";
                }
                case "int": 
                case "long": 
                case "byte": 
                case "double": 
                case "float": 
                case "short": {
                    return "0";
                }
                case "char": {
                    return "'\\0'";
                }
            }
        }
        return "null";
    }

    private String validForCompletes(String returnType) {
        switch (returnType) {
            case "boolean": {
                return "Boolean";
            }
            case "int": {
                return "Integer";
            }
            case "long": {
                return "Long";
            }
            case "byte": {
                return "Byte";
            }
            case "double": {
                return "Double";
            }
            case "float": {
                return "Float";
            }
            case "short": {
                return "Short";
            }
            case "char": {
                return "Character";
            }
        }
        return returnType;
    }

    private String throwsExceptions(Method method) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            if (first) {
                builder.append(" throws ");
            } else {
                builder.append(", ");
            }
            first = false;
            builder.append(exceptionType.getName());
        }
        return builder.toString();
    }

    private boolean isSafeGenerable(Class<?> protocolClass) {
        if (protocolClass.isAnnotationPresent(SafeProxyGenerable.class)) {
            return true;
        }
        return Stream.of(protocolClass.getInterfaces()).map(this::isSafeGenerable).reduce(false, (a, b) -> a != false || b != false);
    }

    private static File rootOfGeneratedSources(DynaType type) {
        return type == DynaType.Main ? new File(Properties.properties.getProperty("proxy.generated.sources.main", "target/generated-sources/")) : new File(Properties.properties.getProperty("proxy.generated.sources.test", "target/generated-test-sources/"));
    }

    public static final class GenericParser {
        private static final Map<String, Boolean> PRIMITIVES = new HashMap<String, Boolean>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("byte", true);
                this.put("short", true);
                this.put("int", true);
                this.put("long", true);
                this.put("char", true);
                this.put("float", true);
                this.put("double", true);
                this.put("boolean", true);
                this.put("void", true);
            }
        };

        private GenericParser() {
        }

        public static Stream<String> genericReferencesOf(Method method) {
            return Stream.concat(Stream.concat(Stream.of(method.getGenericReturnType()), Arrays.stream(method.getGenericParameterTypes())), Stream.of(method.getClass())).flatMap(GenericParser::genericReferencesOf);
        }

        public static Stream<String> dependenciesOf(Class<?> classRef) {
            return Arrays.stream(classRef.getMethods()).filter(GenericParser::instanceOnly).flatMap(GenericParser::dependenciesOf).filter(GenericParser::onlyNotPrimitives).map(GenericParser::normalizeTypeName);
        }

        public static Stream<String> dependenciesOf(Method method) {
            Set genericTypeAlias = GenericParser.genericReferencesOf(method).collect(Collectors.toSet());
            return Stream.concat(Arrays.stream(method.getGenericParameterTypes()), Stream.of(method.getGenericReturnType())).flatMap(GenericParser::typeNameToTypeStream).filter(type -> !genericTypeAlias.contains(GenericParser.normalizeTypeAlias(type))).filter(GenericParser::onlyNotPrimitives).map(GenericParser::normalizeTypeName);
        }

        public static String genericTemplateOf(Method method) {
            Set knownAlias = Arrays.stream(method.getDeclaringClass().getTypeParameters()).flatMap(GenericParser::genericReferencesOf).collect(Collectors.toSet());
            return GenericParser.allTypesOfMethodSignature(method).filter(type -> type instanceof TypeVariable || type instanceof ParameterizedType).flatMap(type -> GenericParser.typeToGenericString(knownAlias, type)).distinct().sorted().map(GenericParser::normalizeTypeName).collect(Collectors.joining(", ", "<", ">")).replace("<>", "");
        }

        public static boolean instanceOnly(Method method) {
            return (method.getModifiers() & 8) == 0;
        }

        public static String parametersTemplateOf(Method method) {
            return Arrays.stream(method.getParameters()).map(param -> String.format("%s %s", GenericParser.normalizeTypeName(param.getParameterizedType().getTypeName()), param.getName())).collect(Collectors.joining(", ", "(", ")"));
        }

        public static String implementsInterfaceTemplateOf(String newClassName, Class<?> classToExtend) {
            StringBuilder template = new StringBuilder("public class ").append(newClassName);
            template.append(Arrays.stream(classToExtend.getTypeParameters()).flatMap(type -> GenericParser.typeToGenericString(new HashSet<String>(), type)).collect(Collectors.joining(", ", "<", ">")).replace("<>", ""));
            template.append(" extends ActorProxyBase<").append(classToExtend.getCanonicalName()).append(">");
            template.append(" implements ").append(classToExtend.getCanonicalName());
            template.append(Arrays.stream(classToExtend.getTypeParameters()).flatMap(GenericParser::genericReferencesOf).collect(Collectors.joining(", ", "<", ">")).replace("<>", ""));
            return template.toString();
        }

        public static String returnTypeOf(Method method) {
            return GenericParser.normalizeTypeName(method.getGenericReturnType().getTypeName());
        }

        private static Stream<String> typeToGenericString(Set<String> classAlias, Type type) {
            if (type instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)type;
                String boundaryType = typeVariable.getBounds()[0].getTypeName();
                String genericAlias = typeVariable.getTypeName();
                if (classAlias.contains(GenericParser.normalizeTypeAlias(genericAlias))) {
                    return Stream.empty();
                }
                if (boundaryType.equals("java.lang.Object")) {
                    return Stream.of(genericAlias);
                }
                return Stream.of(String.format("%s extends %s", genericAlias, GenericParser.normalizeTypeName(boundaryType)));
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                return Arrays.stream(paramType.getActualTypeArguments()).flatMap(arg -> GenericParser.typeToGenericString(classAlias, arg));
            }
            return Stream.empty();
        }

        private static Stream<String> genericReferencesOf(Type type) {
            if (type instanceof TypeVariable) {
                TypeVariable variable = (TypeVariable)type;
                return Stream.of(variable.getName());
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                return Arrays.stream(paramType.getActualTypeArguments()).flatMap(GenericParser::genericReferencesOf);
            }
            return Stream.empty();
        }

        private static Stream<Type> allTypesOfMethodSignature(Method method) {
            return Stream.concat(Stream.concat(Arrays.stream(method.getGenericParameterTypes()), Stream.of(method.getGenericReturnType())), Arrays.stream(method.getGenericExceptionTypes()));
        }

        private static String normalizeTypeAlias(String typeName) {
            return typeName.replace("[]", "");
        }

        private static String normalizeTypeName(String typeName) {
            return typeName.replace("$", ".");
        }

        private static boolean onlyNotPrimitives(String type) {
            return PRIMITIVES.getOrDefault(GenericParser.normalizeTypeAlias(type), false) == false;
        }

        private static Stream<String> typeNameToTypeStream(Type type) {
            if (type instanceof TypeVariable) {
                return Arrays.stream(((TypeVariable)type).getBounds()).flatMap(GenericParser::typeNameToTypeStream);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                return Stream.concat(Arrays.stream(paramType.getActualTypeArguments()).flatMap(GenericParser::typeNameToTypeStream), GenericParser.typeNameToTypeStream(paramType.getRawType()));
            }
            return Arrays.stream(type.getTypeName().replaceAll("[<>]", "==").split("=="));
        }
    }

    public static class Result {
        public final String classname;
        public final String fullyQualifiedClassname;
        public final String source;
        public final File sourceFile;

        private Result(String fullyQualifiedClassname, String classname, String source, File sourceFile) {
            this.fullyQualifiedClassname = fullyQualifiedClassname;
            this.classname = classname;
            this.source = source;
            this.sourceFile = sourceFile;
        }
    }
}

