/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.common.Completes;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class Returns<T> {
    private Object value;

    private Returns(Object value) {
        this.value = value;
    }

    public static <T> Returns<T> value(Completes<T> completes) {
        return new Returns<T>(completes);
    }

    public static <T> Returns<T> value(Future<T> future) {
        return new Returns<T>(future);
    }

    public static <T> Returns<T> value(CompletableFuture<T> completableFuture) {
        return new Returns<T>(completableFuture);
    }

    public boolean isCompletes() {
        return this.value instanceof Completes;
    }

    public boolean isFuture() {
        return this.value instanceof Future;
    }

    public boolean isCompletableFuture() {
        return this.value instanceof CompletableFuture;
    }

    public Completes<T> asCompletes() {
        if (!this.isCompletes()) {
            throw new IllegalStateException(MessageFormat.format("The value type should be Completes<T> but was {0}.", this.value.getClass().getName()));
        }
        return (Completes)this.value;
    }

    public Future<T> asFuture() {
        if (!this.isFuture()) {
            throw new IllegalStateException(MessageFormat.format("The value type should be Future<T> but was {0}.", this.value.getClass().getName()));
        }
        return (Future)this.value;
    }

    public CompletableFuture<T> asCompletableFuture() {
        if (!this.isCompletableFuture()) {
            throw new IllegalStateException(MessageFormat.format("The value type should be CompletableFuture<T> but was {0}.", this.value.getClass().getName()));
        }
        return (CompletableFuture)this.value;
    }
}

