/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Routee;
import io.vlingo.actors.Router;
import io.vlingo.actors.RouterSpecification;
import io.vlingo.actors.Routing;
import java.util.List;

public class RoundRobinRouter<P>
extends Router<P> {
    protected int poolIndex;

    public RoundRobinRouter(RouterSpecification<P> specification) {
        super(specification);
    }

    int poolIndex() {
        return this.poolIndex;
    }

    @Override
    protected Routing<P> computeRouting() {
        return Routing.with(this.nextRoutee());
    }

    protected Routee<P> nextRoutee() {
        List routees = this.routees();
        return routees.get(this.incrementAndGetPoolIndex() % routees.size());
    }

    private int incrementAndGetPoolIndex() {
        this.poolIndex = this.poolIndex == Integer.MAX_VALUE ? 0 : this.poolIndex + 1;
        return this.poolIndex;
    }
}

