/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Address;
import io.vlingo.actors.Addressable;
import io.vlingo.actors.LifeCycle;
import io.vlingo.common.Completes;
import io.vlingo.common.PentaConsumer;
import io.vlingo.common.PentaFunction;
import io.vlingo.common.QuadConsumer;
import io.vlingo.common.QuadFunction;
import io.vlingo.common.TriConsumer;
import io.vlingo.common.TriFunction;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class Routee<P> {
    private final Addressable addressable;
    private P delegate;
    private long messageCount;

    static <T> Routee<T> of(T actor, Addressable addressable) {
        return new Routee<T>(actor, addressable);
    }

    static <T> Routee<T> of(T actor) {
        return new Routee<T>(actor, null);
    }

    Routee(P actor, Addressable addressable) {
        this.delegate = actor;
        this.addressable = addressable;
        this.messageCount = 0L;
    }

    public P delegate() {
        return this.delegate;
    }

    public LifeCycle delegateLifeCycle() {
        return this.addressable.lifeCycle();
    }

    public Address address() {
        return this.addressable.address();
    }

    public int pendingMessages() {
        return this.delegateLifeCycle().environment.mailbox.pendingMessages();
    }

    public long messageCount() {
        return this.messageCount;
    }

    protected <T1> void receiveCommand(BiConsumer<P, T1> consumer, T1 routable1) {
        ++this.messageCount;
        consumer.accept(this.delegate, routable1);
    }

    protected <T1, T2> void receiveCommand(TriConsumer<P, T1, T2> consumer, T1 routable1, T2 routable2) {
        ++this.messageCount;
        consumer.accept(this.delegate, routable1, routable2);
    }

    protected <T1, T2, T3> void receiveCommand(QuadConsumer<P, T1, T2, T3> consumer, T1 routable1, T2 routable2, T3 routable3) {
        ++this.messageCount;
        consumer.accept(this.delegate, routable1, routable2, routable3);
    }

    protected <T1, T2, T3, T4> void receiveCommand(PentaConsumer<P, T1, T2, T3, T4> consumer, T1 routable1, T2 routable2, T3 routable3, T4 routable4) {
        ++this.messageCount;
        consumer.accept(this.delegate, routable1, routable2, routable3, routable4);
    }

    public <T1, R extends Completes<?>> R receiveQuery(BiFunction<P, T1, R> query, T1 routable1) {
        ++this.messageCount;
        return (R)((Completes)query.apply(this.delegate, routable1));
    }

    public <T1, T2, R extends Completes<?>> R receiveQuery(TriFunction<P, T1, T2, R> query, T1 routable1, T2 routable2) {
        ++this.messageCount;
        return (R)((Completes)query.apply(this.delegate, routable1, routable2));
    }

    public <T1, T2, T3, R extends Completes<?>> R receiveQuery(QuadFunction<P, T1, T2, T3, R> query, T1 routable1, T2 routable2, T3 routable3) {
        ++this.messageCount;
        return (R)((Completes)query.apply(this.delegate, routable1, routable2, routable3));
    }

    public <T1, T2, T3, T4, R extends Completes<?>> R receiveQuery(PentaFunction<P, T1, T2, T3, T4, R> query, T1 routable1, T2 routable2, T3 routable3, T4 routable4) {
        ++this.messageCount;
        return (R)((Completes)query.apply(this.delegate, routable1, routable2, routable3, routable4));
    }

    public int hashCode() {
        return this.delegate == null ? 0 : this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Routee other = (Routee)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return "Routee(" + "actor=" + this.delegate + ")";
    }
}

