/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Addressable;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.Protocols;
import io.vlingo.actors.Routee;
import io.vlingo.actors.RouterSpecification;
import io.vlingo.actors.Routing;
import io.vlingo.common.Completes;
import io.vlingo.common.PentaConsumer;
import io.vlingo.common.PentaFunction;
import io.vlingo.common.QuadConsumer;
import io.vlingo.common.QuadFunction;
import io.vlingo.common.TriConsumer;
import io.vlingo.common.TriFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public abstract class Router<P>
extends Actor {
    protected final List<Routee<P>> routees = new ArrayList<Routee<P>>();

    public Router(RouterSpecification<P> specification) {
        this.initRoutees(specification);
    }

    protected void initRoutees(RouterSpecification<P> specification) {
        for (int i = 0; i < specification.initialPoolSize(); ++i) {
            Class[] protocols = new Class[]{specification.routerProtocol(), Addressable.class};
            Protocols two = this.childActorFor(protocols, specification.routerDefinition());
            this.subscribe(Routee.of(two.get(0), (Addressable)two.get(1)));
        }
    }

    protected List<Routee<P>> routees() {
        return Collections.unmodifiableList(this.routees);
    }

    public Routee<P> routeeAt(int index) {
        return index < 0 || index >= this.routees.size() ? null : this.routees.get(index);
    }

    protected void subscribe(Routee<P> routee) {
        if (!this.routees.contains(routee)) {
            this.routees.add(routee);
        }
    }

    protected void subscribe(List<Routee<P>> toSubscribe) {
        toSubscribe.forEach(routee -> this.subscribe((Routee<P>)routee));
    }

    protected void unsubscribe(Routee<P> routee) {
        this.routees.remove(routee);
    }

    protected void unsubscribe(List<Routee<P>> toUnsubscribe) {
        toUnsubscribe.forEach(routee -> this.unsubscribe((Routee<P>)routee));
    }

    protected abstract Routing<P> computeRouting();

    protected <T1> Routing<P> routingFor(T1 routable1) {
        return this.computeRouting();
    }

    protected <T1, T2> Routing<P> routingFor(T1 routable1, T2 routable2) {
        return this.computeRouting();
    }

    protected <T1, T2, T3> Routing<P> routingFor(T1 routable1, T2 routable2, T3 routable3) {
        return this.computeRouting();
    }

    protected <T1, T2, T3, T4> Routing<P> routingFor(T1 routable1, T2 routable2, T3 routable3, T4 routable4) {
        return this.computeRouting();
    }

    protected <T1> void dispatchCommand(BiConsumer<P, T1> action, T1 routable1) {
        this.routingFor(routable1).routees().forEach(routee -> routee.receiveCommand(action, routable1));
    }

    protected <T1, T2> void dispatchCommand(TriConsumer<P, T1, T2> action, T1 routable1, T2 routable2) {
        this.routingFor(routable1, routable2).routees().forEach(routee -> routee.receiveCommand(action, routable1, routable2));
    }

    protected <T1, T2, T3> void dispatchCommand(QuadConsumer<P, T1, T2, T3> action, T1 routable1, T2 routable2, T3 routable3) {
        this.routingFor(routable1, routable2, routable3).routees().forEach(routee -> routee.receiveCommand(action, routable1, routable2, routable3));
    }

    protected <T1, T2, T3, T4> void dispatchCommand(PentaConsumer<P, T1, T2, T3, T4> action, T1 routable1, T2 routable2, T3 routable3, T4 routable4) {
        this.routingFor(routable1, routable2, routable3, routable4).routees().forEach(routee -> routee.receiveCommand(action, routable1, routable2, routable3, routable4));
    }

    protected <T1, R extends Completes<?>> R dispatchQuery(BiFunction<P, T1, R> query, T1 routable1) {
        CompletesEventually completesEventually = this.completesEventually();
        this.routingFor(routable1).first().receiveQuery(query, routable1).andFinallyConsume(completesEventually::with);
        return (R)this.completes();
    }

    protected <T1, T2, R extends Completes<?>> R dispatchQuery(TriFunction<P, T1, T2, R> query, T1 routable1, T2 routable2) {
        CompletesEventually completesEventually = this.completesEventually();
        this.routingFor(routable1, routable2).first().receiveQuery(query, routable1, routable2).andFinallyConsume(completesEventually::with);
        return (R)this.completes();
    }

    protected <T1, T2, T3, R extends Completes<?>> R dispatchQuery(QuadFunction<P, T1, T2, T3, R> query, T1 routable1, T2 routable2, T3 routable3) {
        CompletesEventually completesEventually = this.completesEventually();
        this.routingFor(routable1, routable2).first().receiveQuery(query, routable1, routable2, routable3).andFinallyConsume(completesEventually::with);
        return (R)this.completes();
    }

    protected <T1, T2, T3, T4, R extends Completes<?>> R dispatchQuery(PentaFunction<P, T1, T2, T3, T4, R> query, T1 routable1, T2 routable2, T3 routable3, T4 routable4) {
        CompletesEventually completesEventually = this.completesEventually();
        this.routingFor(routable1, routable2).first().receiveQuery(query, routable1, routable2, routable3, routable4).andFinallyConsume(completesEventually::with);
        return (R)this.completes();
    }
}

