/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.Environment;
import io.vlingo.actors.Supervised;
import io.vlingo.actors.SupervisionStrategy;
import io.vlingo.actors.Supervisor;
import java.util.Collection;

public class StageSupervisedActor
implements Supervised {
    private final Actor actor;
    private final Class<?> protocol;
    private final Throwable throwable;

    @Override
    public Address address() {
        return this.actor.address();
    }

    @Override
    public void escalate() {
        this.supervisor().supervisor().inform(this.throwable, this);
    }

    @Override
    public void restartWithin(long period, int intensity, SupervisionStrategy.Scope scope) {
        if (this.failureThresholdReached(period, intensity)) {
            this.stop(scope);
        } else if (scope == SupervisionStrategy.Scope.One) {
            this.restartWithin(this.actor, period, intensity);
        } else {
            for (Actor actor : this.selfWithSiblings()) {
                this.restartWithin(actor, period, intensity);
            }
        }
    }

    @Override
    public void resume() {
        this.actor.lifeCycle.beforeResume(this.actor, this.throwable, this.protocol);
        this.actor.lifeCycle.resume();
    }

    @Override
    public void stop(SupervisionStrategy.Scope scope) {
        if (scope == SupervisionStrategy.Scope.One) {
            this.actor.stop();
        } else {
            for (Actor actor : this.selfWithSiblings()) {
                actor.stop();
            }
        }
    }

    @Override
    public void suspend() {
        this.actor.lifeCycle.suspend();
    }

    @Override
    public Supervisor supervisor() {
        return this.actor.lifeCycle.supervisor(this.protocol);
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    protected StageSupervisedActor(Class<?> protocol, Actor actor, Throwable throwable) {
        this.protocol = protocol;
        this.actor = actor;
        this.throwable = throwable;
    }

    private Collection<Actor> selfWithSiblings() {
        return this.environmentOf((Actor)this.environmentOf((Actor)this.actor).parent).children;
    }

    private Environment environmentOf(Actor actor) {
        return actor.lifeCycle.environment;
    }

    private boolean failureThresholdReached(long period, int intensity) {
        return this.environmentOf((Actor)this.actor).failureMark.failedWithExcessiveFailures(period, intensity);
    }

    private void restartWithin(Actor actor, long period, int intensity) {
        actor.lifeCycle.beforeRestart(actor, this.throwable, this.protocol);
        actor.lifeCycle.afterRestart(actor, this.throwable, this.protocol);
        this.resume();
    }
}

