/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.LocalMessage;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Message;
import io.vlingo.actors.StowedLocalMessage;
import java.util.LinkedList;
import java.util.Queue;

public class Stowage {
    private Queue<Message> stowedMessages;
    private volatile boolean dispersing = false;
    private volatile boolean stowing = false;

    public Stowage() {
        this.reset();
    }

    public String toString() {
        return "Stowage[stowing=" + this.stowing + ", dispersing=" + this.dispersing + " messages=" + this.stowedMessages + "]";
    }

    int count() {
        return this.stowedMessages.size();
    }

    void dump(Logger logger) {
        for (Message message : this.stowedMessages) {
            logger.debug("STOWED: " + message);
        }
    }

    boolean hasMessages() {
        return !this.stowedMessages.isEmpty();
    }

    Message head() {
        if (this.stowedMessages.isEmpty()) {
            this.reset();
            return null;
        }
        return this.stowedMessages.poll();
    }

    void reset() {
        this.stowedMessages = new LinkedList<Message>();
        this.stowing = false;
        this.dispersing = false;
    }

    boolean isStowing() {
        return this.stowing;
    }

    void stowingMode() {
        this.stowing = true;
        this.dispersing = false;
    }

    boolean isDispersing() {
        return this.dispersing;
    }

    void dispersingMode() {
        this.stowing = false;
        this.dispersing = true;
    }

    void restow(Stowage other) {
        Message message = this.head();
        while (message != null) {
            other.stow(message);
            message = this.head();
        }
    }

    void stow(Message message) {
        if (this.isStowing()) {
            StowedLocalMessage toStow = message.isStowed() ? message : new StowedLocalMessage(message);
            this.stowedMessages.add(toStow);
        }
    }

    Message swapWith(Message newerMessage) {
        if (this.stowedMessages.isEmpty()) {
            this.reset();
            return newerMessage;
        }
        Message olderMessage = this.head();
        this.stowedMessages.add(new StowedLocalMessage((LocalMessage)newerMessage));
        return olderMessage;
    }
}

