/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Address;
import java.util.UUID;

public class UUIDAddress
implements Address {
    private final UUID id;
    private final String name;

    @Override
    public long id() {
        return this.id.getLeastSignificantBits();
    }

    @Override
    public long idSequence() {
        return this.id.timestamp();
    }

    @Override
    public String idSequenceString() {
        return "" + this.id.timestamp();
    }

    @Override
    public String idString() {
        return this.id.toString();
    }

    public UUID idTyped() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name == null ? this.idString() : this.name;
    }

    @Override
    public boolean isDistributable() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.id.equals(((UUIDAddress)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", name=" + (this.name == null ? "(none)" : this.name) + "]";
    }

    @Override
    public int compareTo(Address other) {
        return this.id.compareTo(((UUIDAddress)other).id);
    }

    UUIDAddress(UUID reservedId) {
        this(reservedId, null, false);
    }

    UUIDAddress(UUID reservedId, String name) {
        this(reservedId, name, false);
    }

    UUIDAddress(UUID reservedId, String name, boolean prefixName) {
        this.id = reservedId;
        this.name = name == null ? null : (prefixName ? name + this.id : name);
    }
}

