/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Address;
import io.vlingo.actors.AddressFactory;
import io.vlingo.actors.UUIDAddress;
import io.vlingo.common.identity.IdentityGenerator;
import io.vlingo.common.identity.IdentityGeneratorType;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class UUIDAddressFactory
implements AddressFactory {
    private static final Address None = new UUIDAddress(null, "(none)");
    private final IdentityGenerator generator;
    private final IdentityGeneratorType type;
    private final AtomicLong highId;

    public UUIDAddressFactory(IdentityGeneratorType type) {
        this.type = type;
        this.generator = this.type.generator();
        this.highId = new AtomicLong(0x7FFFFFFFFFFFFFFCL);
    }

    @Override
    public <T> Address findableBy(T id) {
        return new UUIDAddress((UUID)id);
    }

    @Override
    public Address from(long reservedId, String name) {
        return new UUIDAddress(this.uuidFrom(reservedId), name);
    }

    @Override
    public Address from(String idString) {
        return new UUIDAddress(UUID.fromString(idString));
    }

    @Override
    public Address from(String idString, String name) {
        return new UUIDAddress(UUID.fromString(idString), name);
    }

    @Override
    public Address none() {
        return None;
    }

    @Override
    public Address unique() {
        return new UUIDAddress(this.generator.generate());
    }

    @Override
    public Address uniquePrefixedWith(String prefixedWith) {
        return new UUIDAddress(this.generator.generate(), prefixedWith, true);
    }

    @Override
    public Address uniqueWith(String name) {
        return new UUIDAddress(this.generator.generate(name), name);
    }

    @Override
    public Address withHighId() {
        return this.withHighId(null);
    }

    @Override
    public Address withHighId(String name) {
        return new UUIDAddress(this.uuidFrom(this.highId.decrementAndGet()), name);
    }

    @Override
    public long testNextIdValue() {
        throw new UnsupportedOperationException("Unsupported for UUIDAddress.");
    }

    protected UUID uuidFrom(long id) {
        return new UUID(Long.MAX_VALUE, id);
    }

    protected UUID unique(String name) {
        boolean found = false;
        long highest = this.highId.get();
        while (!found) {
            UUID uuid = name == null ? this.generator.generate() : this.generator.generate(name);
            long lsb = uuid.getLeastSignificantBits();
            if (lsb > 0x7FFFFFFFFFFFFFFCL) {
                return uuid;
            }
            if (lsb >= highest) continue;
            return uuid;
        }
        throw new IllegalStateException("Cannot allocate unique address id.");
    }
}

