/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin;

import io.vlingo.actors.Configuration;
import io.vlingo.actors.plugin.Plugin;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PluginLoader {
    private static final String pluginNamePrefix = "plugin.name.";
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();

    public Collection<Plugin> loadEnabledPlugins(Configuration configuration, Properties properties) {
        if (!properties.isEmpty()) {
            for (String enabledPlugin : this.findEnabledPlugins(properties)) {
                this.loadPlugin(configuration, properties, enabledPlugin);
            }
        }
        return this.plugins.values();
    }

    private Set<String> findEnabledPlugins(Properties properties) {
        HashSet<String> enabledPlugins = new HashSet<String>();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(pluginNamePrefix) || !Boolean.parseBoolean(properties.getProperty(key))) continue;
            enabledPlugins.add(key);
        }
        return enabledPlugins;
    }

    private void loadPlugin(Configuration configuration, Properties properties, String enabledPlugin) {
        String pluginName = enabledPlugin.substring(pluginNamePrefix.length());
        String classnameKey = "plugin." + pluginName + ".classname";
        String classname = properties.getProperty(classnameKey);
        try {
            Plugin maybePlugin = this.plugins.get(classname);
            if (maybePlugin == null) {
                Class<?> pluginClass = Class.forName(classname);
                Plugin plugin = (Plugin)pluginClass.newInstance();
                this.plugins.put(classname, plugin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Cannot load plugin " + classname);
        }
    }
}

