/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin;

import java.util.Properties;

public class PluginProperties {
    public final String name;
    private final Properties properties;

    public PluginProperties(String name, Properties properties) {
        this.name = name;
        this.properties = properties;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getString(key, defaultValue.toString());
        return Boolean.parseBoolean(value);
    }

    public Float getFloat(String key, Float defaultValue) {
        String value = this.getString(key, defaultValue.toString());
        return Float.valueOf(Float.parseFloat(value));
    }

    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.getString(key, defaultValue.toString());
        return Integer.parseInt(value);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.getString(key, defaultValue.toString());
        return Long.parseLong(value);
    }

    public String getString(String key, String defaultValue) {
        return this.properties.getProperty(this.key(key), defaultValue);
    }

    private String key(String key) {
        return "plugin." + this.name + "." + key;
    }
}

