/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.completes;

import io.vlingo.actors.Address;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.CompletesEventuallyActor;
import io.vlingo.actors.CompletesEventuallyProvider;
import io.vlingo.actors.Definition;
import io.vlingo.actors.PooledCompletes;
import io.vlingo.actors.Returns;
import io.vlingo.actors.Stage;
import java.util.concurrent.atomic.AtomicLong;

public class CompletesEventuallyPool
implements CompletesEventuallyProvider {
    private final AtomicLong completesEventuallyId = new AtomicLong(0L);
    private final String mailboxName;
    private final CompletesEventually[] pool;
    private final AtomicLong poolIndex;
    private final long poolSize;

    CompletesEventuallyPool(int poolSize, String mailboxName) {
        this.poolSize = poolSize;
        this.mailboxName = mailboxName;
        this.poolIndex = new AtomicLong(0L);
        this.pool = new CompletesEventually[poolSize];
    }

    @Override
    public void close() {
        for (CompletesEventually completes : this.pool) {
            completes.stop();
        }
    }

    @Override
    public CompletesEventually completesEventually() {
        int index = (int)(this.poolIndex.incrementAndGet() % this.poolSize);
        return this.pool[index];
    }

    @Override
    public void initializeUsing(Stage stage) {
        int idx = 0;
        while ((long)idx < this.poolSize) {
            this.pool[idx] = stage.actorFor(CompletesEventually.class, Definition.has(CompletesEventuallyActor.class, CompletesEventuallyActor::new, this.mailboxName, "completes-eventually-" + (idx + 1)));
            ++idx;
        }
    }

    @Override
    public CompletesEventually provideCompletesFor(Returns<?> clientReturns) {
        return new PooledCompletes(this.completesEventuallyId.getAndIncrement(), clientReturns, this.completesEventually());
    }

    @Override
    public CompletesEventually provideCompletesFor(Address address, Returns<?> clientReturns) {
        return new PooledCompletes(this.completesEventuallyId.getAndIncrement(), clientReturns, this.completesEventuallyOf(address));
    }

    private CompletesEventually completesEventuallyOf(Address address) {
        for (CompletesEventually completesEventually : this.pool) {
            if (!completesEventually.address().equals(address)) continue;
            return completesEventually;
        }
        return this.completesEventually();
    }
}

