/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.logging;

import io.vlingo.actors.LoggerProvider;
import io.vlingo.actors.LoggerProviderKeeper;
import java.util.HashMap;
import java.util.Map;

public final class DefaultLoggerProviderKeeper
implements LoggerProviderKeeper {
    private final Map<String, LoggerProviderInfo> loggerProviderInfos = new HashMap<String, LoggerProviderInfo>();

    @Override
    public void close() {
        for (LoggerProviderInfo info : this.loggerProviderInfos.values()) {
            info.loggerProvider.close();
        }
    }

    @Override
    public LoggerProvider findDefault() {
        for (LoggerProviderInfo info : this.loggerProviderInfos.values()) {
            if (!info.isDefault) continue;
            return info.loggerProvider;
        }
        return null;
    }

    @Override
    public LoggerProvider findNamed(String name) {
        LoggerProviderInfo info = this.loggerProviderInfos.get(name);
        if (info != null) {
            return info.loggerProvider;
        }
        throw new IllegalStateException("No registered LoggerProvider named: " + name);
    }

    @Override
    public void keep(String name, boolean isDefault, LoggerProvider loggerProvider) {
        if (this.loggerProviderInfos.isEmpty() || this.findDefault() == null) {
            isDefault = true;
        }
        if (isDefault) {
            this.undefaultCurrentDefault();
        }
        this.loggerProviderInfos.put(name, new LoggerProviderInfo(name, loggerProvider, isDefault));
    }

    private void undefaultCurrentDefault() {
        for (String key : this.loggerProviderInfos.keySet()) {
            LoggerProviderInfo info = this.loggerProviderInfos.get(key);
            if (info == null || !info.isDefault) continue;
            this.loggerProviderInfos.put(key, new LoggerProviderInfo(info.name, info.loggerProvider, false));
        }
    }

    final class LoggerProviderInfo {
        final boolean isDefault;
        final LoggerProvider loggerProvider;
        final String name;

        LoggerProviderInfo(String name, LoggerProvider loggerProvider, boolean isDefault) {
            this.name = name;
            this.loggerProvider = loggerProvider;
            this.isDefault = isDefault;
        }
    }
}

