/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.logging.slf4j;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Logger;
import io.vlingo.actors.logging.LogEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4jLoggerActor
extends Actor
implements Logger {
    private static final String LOGGER_NAME = "Slf4jLogger";
    private static final String MDC_KEY_SOURCE_THREAD = "sourceThread";
    private static final String MDC_KEY_SOURCE_ADDRESS = "sourceAddress";
    private static final String MDC_KEY_EVENT_TIMESTAMP = "eventTimestamp";
    private final Map<Class<?>, org.slf4j.Logger> loggerMap = new HashMap();

    @Override
    public void stop() {
        this.close();
        super.stop();
    }

    @Override
    public String name() {
        return LOGGER_NAME;
    }

    @Override
    public void close() {
        this.loggerMap.clear();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void trace(LogEvent logEvent) {
        Slf4jLoggerActor.withMcd(logEvent, () -> this.getSlf4jLogger(logEvent).trace(logEvent.getMessage(), (Object)logEvent.getArgs(), (Object)logEvent.getThrowable()));
    }

    @Override
    public void debug(LogEvent logEvent) {
        Slf4jLoggerActor.withMcd(logEvent, () -> this.getSlf4jLogger(logEvent).debug(logEvent.getMessage(), (Object)logEvent.getArgs(), (Object)logEvent.getThrowable()));
    }

    @Override
    public void info(LogEvent logEvent) {
        Slf4jLoggerActor.withMcd(logEvent, () -> this.getSlf4jLogger(logEvent).info(logEvent.getMessage(), (Object)logEvent.getArgs(), (Object)logEvent.getThrowable()));
    }

    @Override
    public void warn(LogEvent logEvent) {
        Slf4jLoggerActor.withMcd(logEvent, () -> this.getSlf4jLogger(logEvent).warn(logEvent.getMessage(), (Object)logEvent.getArgs(), (Object)logEvent.getThrowable()));
    }

    @Override
    public void error(LogEvent logEvent) {
        Slf4jLoggerActor.withMcd(logEvent, () -> this.getSlf4jLogger(logEvent).error(logEvent.getMessage(), (Object)logEvent.getArgs(), (Object)logEvent.getThrowable()));
    }

    private org.slf4j.Logger getSlf4jLogger(LogEvent logEvent) {
        return this.loggerMap.computeIfAbsent(logEvent.getSource(), LoggerFactory::getLogger);
    }

    private static void withMcd(LogEvent logEvent, Runnable runWithMdc) {
        try {
            logEvent.getSourceActorAddress().ifPresent(address -> MDC.put((String)MDC_KEY_SOURCE_ADDRESS, (String)address.name()));
            logEvent.getSourceThread().ifPresent(sourceThread -> MDC.put((String)MDC_KEY_SOURCE_THREAD, (String)sourceThread));
            logEvent.getEventTimestamp().ifPresent(instant -> MDC.put((String)MDC_KEY_EVENT_TIMESTAMP, (String)instant.toString()));
            runWithMdc.run();
        }
        finally {
            MDC.remove((String)MDC_KEY_SOURCE_THREAD);
            MDC.remove((String)MDC_KEY_EVENT_TIMESTAMP);
            MDC.remove((String)MDC_KEY_SOURCE_ADDRESS);
        }
    }
}

