/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.logging.slf4j;

import io.vlingo.actors.Configuration;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Logger;
import io.vlingo.actors.LoggerProvider;
import io.vlingo.actors.Registrar;
import io.vlingo.actors.plugin.AbstractPlugin;
import io.vlingo.actors.plugin.Plugin;
import io.vlingo.actors.plugin.PluginConfiguration;
import io.vlingo.actors.plugin.PluginProperties;
import io.vlingo.actors.plugin.logging.slf4j.Slf4jLogger;
import io.vlingo.actors.plugin.logging.slf4j.Slf4jLoggerActor;
import java.util.Properties;

public class Slf4jLoggerPlugin
extends AbstractPlugin
implements Plugin,
LoggerProvider {
    private final Slf4jLoggerPluginConfiguration pluginConfiguration;
    private int pass = 1;
    private Logger logger;

    public static Logger basicInstance() {
        Configuration configuration = Configuration.define();
        Slf4jLoggerPluginConfiguration loggerConfiguration = Slf4jLoggerPluginConfiguration.define();
        loggerConfiguration.build(configuration);
        return new Slf4jLogger(loggerConfiguration.name());
    }

    public static LoggerProvider registerStandardLogger(String name, Registrar registrar) {
        Slf4jLoggerPlugin plugin = new Slf4jLoggerPlugin();
        Slf4jLoggerPluginConfiguration pluginConfiguration = (Slf4jLoggerPluginConfiguration)plugin.configuration();
        Properties properties = new Properties();
        properties.setProperty("plugin." + name + ".defaulLogger", "true");
        pluginConfiguration.buildWith(registrar.world().configuration(), new PluginProperties(name, properties));
        plugin.start(registrar);
        return plugin;
    }

    public Slf4jLoggerPlugin() {
        this.pluginConfiguration = new Slf4jLoggerPluginConfiguration();
    }

    private Slf4jLoggerPlugin(PluginConfiguration configuration) {
        this.pluginConfiguration = (Slf4jLoggerPluginConfiguration)configuration;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void close() {
        this.logger.close();
    }

    @Override
    public PluginConfiguration configuration() {
        return this.pluginConfiguration;
    }

    @Override
    public String name() {
        return this.pluginConfiguration.name();
    }

    @Override
    public int pass() {
        return this.pass;
    }

    @Override
    public void start(Registrar registrar) {
        if (this.pass < 2) {
            this.logger = new Slf4jLogger(this.pluginConfiguration.name());
            registrar.register(this.pluginConfiguration.name(), this.pluginConfiguration.isDefaultLogger(), this);
            this.pass = 2;
        } else if (this.pass == 2 && registrar.world() != null) {
            this.logger = registrar.world().actorFor(Logger.class, Definition.has(Slf4jLoggerActor.class, Slf4jLoggerActor::new));
            registrar.register(this.pluginConfiguration.name(), this.pluginConfiguration.isDefaultLogger(), this);
        }
    }

    @Override
    public Plugin with(PluginConfiguration overrideConfiguration) {
        if (overrideConfiguration == null) {
            return this;
        }
        return new Slf4jLoggerPlugin(overrideConfiguration);
    }

    public static class Slf4jLoggerPluginConfiguration
    implements PluginConfiguration {
        private boolean defaultLogger;
        private String name;

        public boolean isDefaultLogger() {
            return this.defaultLogger;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void build(Configuration configuration) {
            configuration.with(this.defaultLogger().name("vlingo/actors"));
        }

        @Override
        public void buildWith(Configuration configuration, PluginProperties properties) {
            this.name = properties.name;
            this.defaultLogger = properties.getBoolean("defaultLogger", true);
        }

        public Slf4jLoggerPluginConfiguration defaultLogger() {
            this.defaultLogger = true;
            return this;
        }

        public Slf4jLoggerPluginConfiguration name(String name) {
            this.name = name;
            return this;
        }

        public static Slf4jLoggerPluginConfiguration define() {
            return new Slf4jLoggerPluginConfiguration();
        }
    }
}

