/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.mailbox.concurrentqueue;

import io.vlingo.actors.Configuration;
import io.vlingo.actors.Dispatcher;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.MailboxProvider;
import io.vlingo.actors.Registrar;
import io.vlingo.actors.plugin.AbstractPlugin;
import io.vlingo.actors.plugin.Plugin;
import io.vlingo.actors.plugin.PluginConfiguration;
import io.vlingo.actors.plugin.PluginProperties;
import io.vlingo.actors.plugin.mailbox.concurrentqueue.ConcurrentQueueMailbox;
import io.vlingo.actors.plugin.mailbox.concurrentqueue.ExecutorDispatcher;

public class ConcurrentQueueMailboxPlugin
extends AbstractPlugin
implements Plugin,
MailboxProvider {
    private final ConcurrentQueueMailboxPluginConfiguration configuration;
    private Dispatcher executorDispatcher;

    public ConcurrentQueueMailboxPlugin() {
        this.configuration = new ConcurrentQueueMailboxPluginConfiguration();
    }

    @Override
    public void close() {
        this.executorDispatcher.close();
    }

    @Override
    public PluginConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public String name() {
        return this.configuration.name();
    }

    @Override
    public int pass() {
        return 1;
    }

    @Override
    public void start(Registrar registrar) {
        this.executorDispatcher = new ExecutorDispatcher(Runtime.getRuntime().availableProcessors(), this.configuration.numberOfDispatchers, this.configuration.numberOfDispatchersFactor);
        registrar.register(this.configuration.name(), this.configuration.isDefaultMailbox(), this);
    }

    @Override
    public Mailbox provideMailboxFor(int hashCode) {
        return new ConcurrentQueueMailbox(this.executorDispatcher, this.configuration.dispatcherThrottlingCount());
    }

    @Override
    public Plugin with(PluginConfiguration overrideConfiguration) {
        if (overrideConfiguration == null) {
            return this;
        }
        return new ConcurrentQueueMailboxPlugin(overrideConfiguration);
    }

    private ConcurrentQueueMailboxPlugin(PluginConfiguration configuration) {
        this.configuration = (ConcurrentQueueMailboxPluginConfiguration)configuration;
    }

    @Override
    public Mailbox provideMailboxFor(int hashCode, Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new IllegalArgumentException("Dispatcher must not be null.");
        }
        return new ConcurrentQueueMailbox(dispatcher, this.configuration.dispatcherThrottlingCount());
    }

    public static class ConcurrentQueueMailboxPluginConfiguration
    implements PluginConfiguration {
        private boolean defaultMailbox;
        private int dispatcherThrottlingCount;
        private String name = "queueMailbox";
        private int numberOfDispatchers;
        private float numberOfDispatchersFactor;

        public static ConcurrentQueueMailboxPluginConfiguration define() {
            return new ConcurrentQueueMailboxPluginConfiguration();
        }

        public ConcurrentQueueMailboxPluginConfiguration defaultMailbox() {
            this.defaultMailbox = true;
            return this;
        }

        public boolean isDefaultMailbox() {
            return this.defaultMailbox;
        }

        public ConcurrentQueueMailboxPluginConfiguration dispatcherThrottlingCount(int dispatcherThrottlingCount) {
            this.dispatcherThrottlingCount = dispatcherThrottlingCount;
            return this;
        }

        public int dispatcherThrottlingCount() {
            return this.dispatcherThrottlingCount;
        }

        public ConcurrentQueueMailboxPluginConfiguration numberOfDispatchersFactor(float numberOfDispatchersFactor) {
            this.numberOfDispatchersFactor = numberOfDispatchersFactor;
            return this;
        }

        public ConcurrentQueueMailboxPluginConfiguration numberOfDispatchers(int numberOfDispatchers) {
            this.numberOfDispatchers = numberOfDispatchers;
            return this;
        }

        public int numberOfDispatchers() {
            return this.numberOfDispatchers;
        }

        public float numberOfDispatchersFactor() {
            return this.numberOfDispatchersFactor;
        }

        @Override
        public void build(Configuration configuration) {
            configuration.with(this.defaultMailbox().numberOfDispatchersFactor(1.5f).dispatcherThrottlingCount(1));
        }

        @Override
        public void buildWith(Configuration configuration, PluginProperties properties) {
            this.name = properties.name;
            this.defaultMailbox = properties.getBoolean("defaultMailbox", true);
            this.dispatcherThrottlingCount = properties.getInteger("dispatcherThrottlingCount", 1);
            this.numberOfDispatchersFactor = properties.getFloat("numberOfDispatchersFactor", Float.valueOf(1.5f)).floatValue();
            this.numberOfDispatchers = properties.getInteger("numberOfDispatchers", 0);
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

