/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.mailbox.sharedringbuffer;

import io.vlingo.actors.Configuration;
import io.vlingo.actors.Dispatcher;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.MailboxProvider;
import io.vlingo.actors.Registrar;
import io.vlingo.actors.plugin.AbstractPlugin;
import io.vlingo.actors.plugin.Plugin;
import io.vlingo.actors.plugin.PluginConfiguration;
import io.vlingo.actors.plugin.PluginProperties;
import io.vlingo.actors.plugin.mailbox.sharedringbuffer.RingBufferDispatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SharedRingBufferMailboxPlugin
extends AbstractPlugin
implements Plugin,
MailboxProvider {
    private final SharedRingBufferMailboxPluginConfiguration configuration;
    private final Map<Integer, RingBufferDispatcher> dispatchers;

    public SharedRingBufferMailboxPlugin() {
        this.configuration = new SharedRingBufferMailboxPluginConfiguration();
        this.dispatchers = new ConcurrentHashMap<Integer, RingBufferDispatcher>(1);
    }

    @Override
    public void close() {
        this.dispatchers.values().stream().forEach(dispatcher -> dispatcher.close());
    }

    @Override
    public PluginConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public String name() {
        return this.configuration.name();
    }

    @Override
    public int pass() {
        return 1;
    }

    @Override
    public void start(Registrar registrar) {
        registrar.register(this.configuration.name(), this.configuration.isDefaultMailbox(), this);
    }

    @Override
    public Plugin with(PluginConfiguration overrideConfiguration) {
        if (overrideConfiguration == null) {
            return this;
        }
        return new SharedRingBufferMailboxPlugin(overrideConfiguration);
    }

    private SharedRingBufferMailboxPlugin(PluginConfiguration configuration) {
        this.configuration = (SharedRingBufferMailboxPluginConfiguration)configuration;
        this.dispatchers = new ConcurrentHashMap<Integer, RingBufferDispatcher>(1);
    }

    @Override
    public Mailbox provideMailboxFor(int hashCode) {
        return this.provideMailboxFor(hashCode, null);
    }

    @Override
    public Mailbox provideMailboxFor(int hashCode, Dispatcher dispatcher) {
        RingBufferDispatcher maybeDispatcher;
        RingBufferDispatcher ringBufferDispatcher = maybeDispatcher = dispatcher != null ? (RingBufferDispatcher)dispatcher : this.dispatchers.get(hashCode);
        if (maybeDispatcher == null) {
            RingBufferDispatcher newDispatcher = new RingBufferDispatcher(this.configuration.ringSize(), this.configuration.fixedBackoff(), this.configuration.notifyOnSend(), this.configuration.dispatcherThrottlingCount());
            RingBufferDispatcher otherDispatcher = this.dispatchers.putIfAbsent(hashCode, newDispatcher);
            if (otherDispatcher != null) {
                otherDispatcher.start();
                return otherDispatcher.mailbox();
            }
            newDispatcher.start();
            return newDispatcher.mailbox();
        }
        return maybeDispatcher.mailbox();
    }

    public static class SharedRingBufferMailboxPluginConfiguration
    implements PluginConfiguration {
        private boolean defaultMailbox;
        private int dispatcherThrottlingCount;
        private int fixedBackoff;
        private String name = "ringMailbox";
        private boolean notifyOnSend;
        private int ringSize;

        public static SharedRingBufferMailboxPluginConfiguration define() {
            return new SharedRingBufferMailboxPluginConfiguration();
        }

        public SharedRingBufferMailboxPluginConfiguration defaultMailbox() {
            this.defaultMailbox = true;
            return this;
        }

        public boolean isDefaultMailbox() {
            return this.defaultMailbox;
        }

        public SharedRingBufferMailboxPluginConfiguration dispatcherThrottlingCount(int dispatcherThrottlingCount) {
            this.dispatcherThrottlingCount = dispatcherThrottlingCount;
            return this;
        }

        public int dispatcherThrottlingCount() {
            return this.dispatcherThrottlingCount;
        }

        public SharedRingBufferMailboxPluginConfiguration fixedBackoff(int fixedBackoff) {
            this.fixedBackoff = fixedBackoff;
            return this;
        }

        public int fixedBackoff() {
            return this.fixedBackoff;
        }

        public SharedRingBufferMailboxPluginConfiguration notifyOnSend(boolean notifyOnSend) {
            this.notifyOnSend = notifyOnSend;
            return this;
        }

        public boolean notifyOnSend() {
            return this.notifyOnSend;
        }

        public SharedRingBufferMailboxPluginConfiguration ringSize(int ringSize) {
            this.ringSize = ringSize;
            return this;
        }

        public int ringSize() {
            return this.ringSize;
        }

        @Override
        public void build(Configuration configuration) {
            configuration.with(this.ringSize(65535).fixedBackoff(2).notifyOnSend(false).dispatcherThrottlingCount(10));
        }

        @Override
        public void buildWith(Configuration configuration, PluginProperties properties) {
            this.name = properties.name;
            this.defaultMailbox = properties.getBoolean("defaultMailbox", false);
            this.dispatcherThrottlingCount = properties.getInteger("dispatcherThrottlingCount", 1);
            this.fixedBackoff = properties.getInteger("fixedBackoff", 2);
            this.notifyOnSend = properties.getBoolean("notifyOnSend", false);
            this.ringSize = properties.getInteger("size", 65535);
            configuration.with(this);
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

