/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.plugin.supervision;

import io.vlingo.actors.Actor;

class ConfiguredSupervisor {
    public final String stageName;
    public final Class<? extends Actor> supervisorClass;
    public final String supervisorName;
    public final Class<?> supervisedProtocol;

    static Class<?> protocolFrom(String supervisedProtocol) {
        try {
            return Class.forName(supervisedProtocol);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load class for: " + supervisedProtocol);
        }
    }

    static Class<? extends Actor> supervisorFrom(String supervisorClassname) {
        try {
            return Class.forName(supervisorClassname);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load class for: " + supervisorClassname);
        }
    }

    public int hashCode() {
        return 31 * this.stageName.hashCode() + this.supervisorName.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        ConfiguredSupervisor otherSupervisor = (ConfiguredSupervisor)other;
        return this.stageName.equals(otherSupervisor.stageName) && this.supervisorName.equals(otherSupervisor.supervisorName) && this.supervisedProtocol == null && otherSupervisor.supervisedProtocol == null || this.supervisedProtocol != null && otherSupervisor.supervisedProtocol != null && this.supervisedProtocol.equals(otherSupervisor.supervisedProtocol) && this.supervisorClass.equals(otherSupervisor.supervisorClass);
    }

    ConfiguredSupervisor(String stageName, String supervisorName, Class<?> supervisedProtocol, Class<? extends Actor> supervisorClass) {
        this.stageName = stageName;
        this.supervisorName = supervisorName;
        this.supervisedProtocol = supervisedProtocol;
        this.supervisorClass = supervisorClass;
    }

    ConfiguredSupervisor(String stageName, String supervisorName, String supervisedProtocol, String supervisorClassname) {
        this.stageName = stageName;
        this.supervisorName = supervisorName;
        this.supervisedProtocol = ConfiguredSupervisor.protocolFrom(supervisedProtocol);
        this.supervisorClass = ConfiguredSupervisor.supervisorFrom(supervisorClassname);
    }

    ConfiguredSupervisor(String stageName, String supervisorName, Class<? extends Actor> supervisorClass) {
        this.stageName = stageName;
        this.supervisorName = supervisorName;
        this.supervisedProtocol = null;
        this.supervisorClass = supervisorClass;
    }

    ConfiguredSupervisor(String stageName, String supervisorName, String supervisorClassname) {
        this.stageName = stageName;
        this.supervisorName = supervisorName;
        this.supervisedProtocol = null;
        this.supervisorClass = ConfiguredSupervisor.supervisorFrom(supervisorClassname);
    }
}

