/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.testkit;

import io.vlingo.actors.testkit.TestUntil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AccessSafely {
    private final AtomicInteger totalWrites = new AtomicInteger(0);
    private final Object lock;
    private final Map<String, BiConsumer<?, ?>> biConsumers;
    private final Map<String, Consumer<?>> consumers;
    private final Map<String, Function<?, ?>> functions;
    private final Map<String, Supplier<?>> suppliers;
    private final TestUntil until;

    private <T, R> Function<T, R> getRequiredFunction(String name) {
        Function<?, ?> function = this.functions.get(name);
        if (function == null) {
            throw new IllegalArgumentException("Unknown function: " + name);
        }
        return function;
    }

    private <T> Supplier<T> getRequiredSupplier(String name) {
        Supplier<?> supplier = this.suppliers.get(name);
        if (supplier == null) {
            throw new IllegalArgumentException("Unknown supplier: " + name);
        }
        return supplier;
    }

    public static AccessSafely afterCompleting(int happenings) {
        return new AccessSafely(happenings);
    }

    public static AccessSafely immediately() {
        return new AccessSafely();
    }

    public AccessSafely resetAfterCompletingTo(int happenings) {
        return new AccessSafely(this, happenings);
    }

    public <T, R> AccessSafely readingWith(String name, Function<T, R> function) {
        this.functions.put(name, function);
        return this;
    }

    public <T> AccessSafely readingWith(String name, Supplier<T> supplier) {
        this.suppliers.put(name, supplier);
        return this;
    }

    public <T> AccessSafely writingWith(String name, Consumer<T> consumer) {
        this.consumers.put(name, consumer);
        return this;
    }

    public <T1, T2> AccessSafely writingWith(String name, BiConsumer<T1, T2> consumer) {
        this.biConsumers.put(name, consumer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readFrom(String name) {
        Supplier<T> supplier = this.getRequiredSupplier(name);
        this.until.completes();
        Object object = this.lock;
        synchronized (object) {
            return supplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> R readFrom(String name, T parameter) {
        Function<T, R> function = this.getRequiredFunction(name);
        this.until.completes();
        Object object = this.lock;
        synchronized (object) {
            return function.apply(parameter);
        }
    }

    public <T> T readFromExpecting(String name, T expected) {
        return this.readFromExpecting(name, expected, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readFromExpecting(String name, T expected, long retries) {
        Supplier<T> supplier = this.getRequiredSupplier(name);
        for (long count = 0L; count < retries; ++count) {
            Object object = this.lock;
            synchronized (object) {
                T value = supplier.get();
                if (expected == value || expected.equals(value)) {
                    return value;
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Did not reach expected value: " + expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readFromNow(String name) {
        Supplier<T> supplier = this.getRequiredSupplier(name);
        Object object = this.lock;
        synchronized (object) {
            return supplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> R readFromNow(String name, T parameter) {
        Function<T, R> function = this.getRequiredFunction(name);
        Object object = this.lock;
        synchronized (object) {
            return function.apply(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeUsing(String name, T value) {
        Consumer<?> consumer = this.consumers.get(name);
        if (consumer == null) {
            throw new IllegalArgumentException("Unknown function: " + name);
        }
        Object object = this.lock;
        synchronized (object) {
            this.totalWrites.incrementAndGet();
            consumer.accept(value);
            this.until.happened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1, T2> void writeUsing(String name, T1 value1, T2 value2) {
        BiConsumer<?, ?> biConsumer = this.biConsumers.get(name);
        if (biConsumer == null) {
            throw new IllegalArgumentException("Unknown function: " + name);
        }
        Object object = this.lock;
        synchronized (object) {
            this.totalWrites.incrementAndGet();
            biConsumer.accept(value1, value2);
            this.until.happened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalWrites() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalWrites.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalWritesGreaterThan(int lesser, long retries) {
        for (long count = 0L; count < retries; ++count) {
            Object object = this.lock;
            synchronized (object) {
                int total = this.totalWrites.get();
                if (total > lesser) {
                    return total;
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Did not reach expected value: " + (lesser + 1));
    }

    private AccessSafely(int happenings) {
        this.until = TestUntil.happenings(happenings);
        this.biConsumers = new HashMap();
        this.consumers = new HashMap();
        this.functions = new HashMap();
        this.suppliers = new HashMap();
        this.lock = new Object();
    }

    private AccessSafely(AccessSafely existing, int happenings) {
        this.until = TestUntil.happenings(happenings);
        this.biConsumers = existing.biConsumers;
        this.consumers = existing.consumers;
        this.functions = existing.functions;
        this.suppliers = existing.suppliers;
        this.lock = new Object();
    }

    private AccessSafely() {
        this(0);
    }
}

