/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.testkit;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.testkit.TestContext;
import io.vlingo.actors.testkit.TestState;
import io.vlingo.actors.testkit.TestStateView;

public class TestActor<T>
implements TestStateView {
    private final Actor actor;
    private final Address address;
    private final T protocolActor;
    private TestContext context;

    public TestActor(Actor actor, T protocol, Address address) {
        this.actor = actor;
        this.protocolActor = protocol;
        this.address = address;
        this.context = new TestContext();
        this.actor.viewTestStateInitialization(this.context);
    }

    public T actor() {
        return this.protocolActor;
    }

    public <O> O actorAs() {
        return (O)this.protocolActor;
    }

    public Address address() {
        return this.address;
    }

    public Actor actorInside() {
        return this.actor;
    }

    public TestContext context() {
        return this.context;
    }

    public TestContext andNowCompleteWithHappenings(int times) {
        this.context = this.context.resetAfterCompletingTo(times);
        return this.context;
    }

    public <V> V mustComplete() {
        return (V)this.context.mustComplete();
    }

    @Override
    public TestState viewTestState() {
        return this.actor.viewTestState();
    }
}

