/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors.testkit;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class TestUntil {
    private CountDownLatch latch;

    public static TestUntil happenings(int times) {
        TestUntil waiter = new TestUntil(times);
        return waiter;
    }

    public void completeNow() {
        while (this.latch.getCount() > 0L) {
            this.happened();
        }
    }

    public void completes() {
        try {
            this.latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean completesWithin(long timeout) {
        try {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
            return this.latch.getCount() == 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public TestUntil happened() {
        this.latch.countDown();
        return this;
    }

    public int remaining() {
        return (int)this.latch.getCount();
    }

    public void resetHappeningsTo(int times) {
        this.latch = new CountDownLatch(times);
    }

    public String toString() {
        return "TestUntil[count=" + this.latch.getCount() + "]";
    }

    private TestUntil(int count) {
        this.latch = new CountDownLatch(count);
    }
}

