/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.ArgumentLock;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.ProxyGenerator;
import io.vlingo.xoom.common.compiler.DynaClassLoader;
import io.vlingo.xoom.common.compiler.DynaCompiler;
import io.vlingo.xoom.common.compiler.DynaNaming;
import java.lang.reflect.Constructor;
import java.util.concurrent.locks.Lock;

public final class ActorProxy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T createFor(Class<T> protocol, Actor actor, Mailbox mailbox) {
        T maybeCachedProxy = actor.lifeCycle.environment.lookUpProxy(protocol);
        if (maybeCachedProxy != null) {
            return maybeCachedProxy;
        }
        Object newProxy = null;
        String proxyClassname = DynaNaming.fullyQualifiedClassnameFor(protocol, (String)"__Proxy");
        Lock lock = ArgumentLock.acquire(protocol);
        lock.lock();
        try {
            newProxy = ActorProxy.tryCreate(protocol, actor, mailbox, proxyClassname);
        }
        catch (Exception e) {
            newProxy = ActorProxy.tryGenerateCreate(protocol, actor, mailbox, proxyClassname);
        }
        finally {
            if (newProxy != null) {
                actor.lifeCycle.environment.cacheProxy(newProxy);
            }
            lock.unlock();
        }
        return newProxy;
    }

    private static DynaClassLoader classLoaderFor(Actor actor) {
        DynaClassLoader classLoader = (DynaClassLoader)actor.lifeCycle.environment.stage.world().classLoader();
        if (classLoader == null) {
            classLoader = new DynaClassLoader(ActorProxy.class.getClassLoader());
            actor.stage().world().classLoader(classLoader);
        }
        return classLoader;
    }

    private static Class<?> loadProxyClassFor(String targetClassname, Actor actor) throws ClassNotFoundException {
        Class<?> proxyClass = Class.forName(targetClassname, true, (ClassLoader)ActorProxy.classLoaderFor(actor));
        return proxyClass;
    }

    private static <T> T tryCreate(Class<T> protocol, Actor actor, Mailbox mailbox, String targetClassname) throws Exception {
        Class<?> proxyClass = ActorProxy.loadProxyClassFor(targetClassname, actor);
        return (T)ActorProxy.tryCreateWithProxyClass(proxyClass, actor, mailbox);
    }

    private static <T> T tryCreateWithProxyClass(Class<T> proxyClass, Actor actor, Mailbox mailbox) throws Exception {
        Constructor<T> ctor = proxyClass.getConstructor(Actor.class, Mailbox.class);
        return ctor.newInstance(actor, mailbox);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T tryGenerateCreate(Class<T> protocol, Actor actor, Mailbox mailbox, String targetClassname) {
        DynaClassLoader classLoader = ActorProxy.classLoaderFor(actor);
        try (ProxyGenerator generator = ProxyGenerator.forMain((ClassLoader)classLoader, true, actor.logger());){
            T t = ActorProxy.tryGenerateCreate(protocol, actor, mailbox, generator, targetClassname);
            return t;
        }
        catch (Exception emain) {
            try (ProxyGenerator generator2 = ProxyGenerator.forTest((ClassLoader)classLoader, true, actor.logger());){
                T t = ActorProxy.tryGenerateCreate(protocol, actor, mailbox, generator2, targetClassname);
                return t;
            }
            catch (Exception etest) {
                throw new IllegalArgumentException("Actor proxy " + protocol.getName() + " not created for main or test: " + etest.getMessage(), etest);
            }
        }
    }

    private static <T> T tryGenerateCreate(Class<T> protocol, Actor actor, Mailbox mailbox, ProxyGenerator generator, String targetClassname) {
        try {
            ProxyGenerator.Result result = generator.generateFor(protocol.getName());
            DynaCompiler.Input input = new DynaCompiler.Input(protocol, targetClassname, result.source, result.sourceFile, ActorProxy.classLoaderFor(actor), generator.type(), true);
            DynaCompiler proxyCompiler = new DynaCompiler();
            Class proxyClass = proxyCompiler.compile(input);
            return ActorProxy.tryCreateWithProxyClass(proxyClass, actor, mailbox);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Actor proxy " + protocol.getName() + " not created because: " + e.getMessage(), e);
        }
    }
}

