/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.Stage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ActorProxyBase<T>
implements Externalizable {
    private static final long serialVersionUID = -2047182900594333760L;
    public Class<T> protocol;
    public Definition.SerializationProxy definition;
    public Address address;

    public static <T> T thunk(ActorProxyBase<?> proxy, Actor actor, T arg) {
        return proxy.isDistributable() ? ActorProxyBase.thunk(actor.lifeCycle.environment.stage, arg) : arg;
    }

    public static <T> T thunk(Stage stage, T arg) {
        if (arg instanceof ActorProxyBase) {
            ActorProxyBase base = (ActorProxyBase)arg;
            return stage.lookupOrStartThunk(base.protocol, Definition.from(stage, base.definition, stage.world().defaultLogger()), base.address);
        }
        return arg;
    }

    public ActorProxyBase(Class<T> protocol, Definition.SerializationProxy definition, Address address) {
        this.protocol = protocol;
        this.definition = definition;
        this.address = address;
    }

    public ActorProxyBase() {
    }

    public final boolean isDistributable() {
        return this.address.isDistributable();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.protocol);
        out.writeObject(this.definition);
        out.writeObject(this.address);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.protocol = (Class)in.readObject();
        this.definition = (Definition.SerializationProxy)in.readObject();
        this.address = (Address)in.readObject();
    }
}

