/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.AddressFactory;
import io.vlingo.xoom.actors.BasicAddress;
import java.util.concurrent.atomic.AtomicLong;

final class BasicAddressFactory
implements AddressFactory {
    static final Address None = new BasicAddress(0L, "(none)");
    private final AtomicLong highId = new AtomicLong(0x7FFFFFFFFFFFFFFCL);
    private final AtomicLong nextId = new AtomicLong(1L);

    @Override
    public <T> Address findableBy(T id) {
        return new BasicAddress((Long)id);
    }

    @Override
    public Address from(long reservedId, String name) {
        return new BasicAddress(reservedId, name);
    }

    @Override
    public Address from(String idString) {
        return new BasicAddress(Long.parseLong(idString));
    }

    @Override
    public Address from(String idString, String name) {
        return new BasicAddress(Long.parseLong(idString), name);
    }

    @Override
    public Address none() {
        return None;
    }

    @Override
    public Address unique() {
        return new BasicAddress(this.nextId.getAndIncrement());
    }

    @Override
    public Address uniquePrefixedWith(String prefixedWith) {
        return new BasicAddress(this.nextId.getAndIncrement(), prefixedWith, true);
    }

    @Override
    public Address uniqueWith(String name) {
        return new BasicAddress(this.nextId.getAndIncrement(), name);
    }

    @Override
    public Address withHighId() {
        return this.withHighId(null);
    }

    @Override
    public Address withHighId(String name) {
        return new BasicAddress(this.highId.decrementAndGet(), name);
    }

    @Override
    public long testNextIdValue() {
        return this.nextId.get();
    }

    public String toString() {
        return "BasicAddressFactory[highId=" + this.highId.get() + ", nextId=" + this.nextId.get() + "]";
    }

    BasicAddressFactory() {
    }
}

