/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.AddressFactory;
import io.vlingo.xoom.actors.DirectoryEvictionConfiguration;
import io.vlingo.xoom.actors.World;
import io.vlingo.xoom.actors.plugin.Plugin;
import io.vlingo.xoom.actors.plugin.PluginConfiguration;
import io.vlingo.xoom.actors.plugin.PluginFactory;
import io.vlingo.xoom.actors.plugin.PluginLoader;
import io.vlingo.xoom.actors.plugin.PluginProperties;
import io.vlingo.xoom.actors.plugin.completes.PooledCompletesPlugin;
import io.vlingo.xoom.actors.plugin.eviction.DirectoryEvictionPlugin;
import io.vlingo.xoom.actors.plugin.logging.slf4j.Slf4jLoggerPlugin;
import io.vlingo.xoom.actors.plugin.mailbox.agronampscarrayqueue.ManyToOneConcurrentArrayQueuePlugin;
import io.vlingo.xoom.actors.plugin.mailbox.concurrentqueue.ConcurrentQueueMailboxPlugin;
import io.vlingo.xoom.actors.plugin.mailbox.sharedringbuffer.SharedRingBufferMailboxPlugin;
import io.vlingo.xoom.actors.plugin.supervision.CommonSupervisorsPlugin;
import io.vlingo.xoom.actors.plugin.supervision.DefaultSupervisorOverridePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;

public class Configuration {
    private ConcurrentQueueMailboxPlugin.ConcurrentQueueMailboxPluginConfiguration concurrentQueueMailboxPluginConfiguration;
    private CommonSupervisorsPlugin.CommonSupervisorsPluginConfiguration commonSupervisorsPluginConfiguration;
    private DefaultSupervisorOverridePlugin.DefaultSupervisorOverridePluginConfiguration defaultSupervisorOverridePluginConfiguration;
    private Slf4jLoggerPlugin.Slf4jLoggerPluginConfiguration slf4jPluginConfiguration;
    private PooledCompletesPlugin.PooledCompletesPluginConfiguration pooledCompletesPluginConfiguration;
    private ManyToOneConcurrentArrayQueuePlugin.ManyToOneConcurrentArrayQueuePluginConfiguration manyToOneConcurrentArrayQueuePluginConfiguration;
    private SharedRingBufferMailboxPlugin.SharedRingBufferMailboxPluginConfiguration sharedRingBufferMailboxPluginConfiguration;
    private DirectoryEvictionConfiguration directoryEvictionConfiguration;
    private String mainProxyGeneratedClassesPath;
    private String mainProxyGeneratedSourcesPath;
    private String testProxyGeneratedClassesPath;
    private String testProxyGeneratedSourcesPath;
    private final Map<String, PluginConfiguration> configurationOverrides = new HashMap<String, PluginConfiguration>();
    private final boolean mergeProperties;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final Properties properties;
    private AddressFactory addressFactory;

    public static Configuration define() {
        return new Configuration();
    }

    public static Configuration defineAlongWith(Properties properties) {
        return new Configuration(properties, true);
    }

    public static Configuration defineWith(Properties properties) {
        return new Configuration(properties, false);
    }

    public Collection<Plugin> allPlugins() {
        return Collections.unmodifiableCollection(this.plugins);
    }

    public Configuration with(AddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        return this;
    }

    public AddressFactory addressFactoryOr(Supplier<AddressFactory> addressFactorySupplier) {
        return this.addressFactory == null ? addressFactorySupplier.get() : this.addressFactory;
    }

    public Configuration with(CommonSupervisorsPlugin.CommonSupervisorsPluginConfiguration configuration) {
        if (this.commonSupervisorsPluginConfiguration == null) {
            this.commonSupervisorsPluginConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public CommonSupervisorsPlugin.CommonSupervisorsPluginConfiguration commonSupervisorsPluginConfiguration() {
        return this.commonSupervisorsPluginConfiguration;
    }

    public Configuration with(ConcurrentQueueMailboxPlugin.ConcurrentQueueMailboxPluginConfiguration configuration) {
        if (this.concurrentQueueMailboxPluginConfiguration == null) {
            this.concurrentQueueMailboxPluginConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public ConcurrentQueueMailboxPlugin.ConcurrentQueueMailboxPluginConfiguration concurrentQueueMailboxPluginConfiguration() {
        return this.concurrentQueueMailboxPluginConfiguration;
    }

    public Configuration with(DefaultSupervisorOverridePlugin.DefaultSupervisorOverridePluginConfiguration configuration) {
        if (this.defaultSupervisorOverridePluginConfiguration == null) {
            this.defaultSupervisorOverridePluginConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public DefaultSupervisorOverridePlugin.DefaultSupervisorOverridePluginConfiguration defaultSupervisorOverridePluginConfiguration() {
        return this.defaultSupervisorOverridePluginConfiguration;
    }

    public Configuration with(Slf4jLoggerPlugin.Slf4jLoggerPluginConfiguration configuration) {
        this.slf4jPluginConfiguration = configuration;
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public Slf4jLoggerPlugin.Slf4jLoggerPluginConfiguration slf4jPluginConfiguration() {
        return this.slf4jPluginConfiguration;
    }

    public Configuration with(ManyToOneConcurrentArrayQueuePlugin.ManyToOneConcurrentArrayQueuePluginConfiguration configuration) {
        if (this.manyToOneConcurrentArrayQueuePluginConfiguration == null) {
            this.manyToOneConcurrentArrayQueuePluginConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public ManyToOneConcurrentArrayQueuePlugin.ManyToOneConcurrentArrayQueuePluginConfiguration manyToOneConcurrentArrayQueuePluginConfiguration() {
        return this.manyToOneConcurrentArrayQueuePluginConfiguration;
    }

    public Configuration with(PooledCompletesPlugin.PooledCompletesPluginConfiguration configuration) {
        if (this.pooledCompletesPluginConfiguration == null) {
            this.pooledCompletesPluginConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public PooledCompletesPlugin.PooledCompletesPluginConfiguration pooledCompletesPluginConfiguration() {
        return this.pooledCompletesPluginConfiguration;
    }

    public Configuration with(SharedRingBufferMailboxPlugin.SharedRingBufferMailboxPluginConfiguration configuration) {
        if (this.sharedRingBufferMailboxPluginConfiguration == null) {
            this.sharedRingBufferMailboxPluginConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public SharedRingBufferMailboxPlugin.SharedRingBufferMailboxPluginConfiguration sharedRingBufferMailboxPluginConfiguration() {
        return this.sharedRingBufferMailboxPluginConfiguration;
    }

    public Configuration with(DirectoryEvictionConfiguration configuration) {
        if (this.directoryEvictionConfiguration == null) {
            this.directoryEvictionConfiguration = configuration;
        }
        this.configurationOverrides.put(configuration.getClass().getSimpleName(), configuration);
        return this;
    }

    public DirectoryEvictionConfiguration directoryEvictionConfiguration() {
        return this.directoryEvictionConfiguration;
    }

    public Configuration usingMainProxyGeneratedClassesPath(String path) {
        this.mainProxyGeneratedClassesPath = path;
        return this;
    }

    public String mainProxyGeneratedClassesPath() {
        return this.mainProxyGeneratedClassesPath;
    }

    public Configuration usingMainProxyGeneratedSourcesPath(String path) {
        this.mainProxyGeneratedSourcesPath = path;
        return this;
    }

    public String mainProxyGeneratedSourcesPath() {
        return this.mainProxyGeneratedSourcesPath;
    }

    public Configuration usingTestProxyGeneratedClassesPath(String path) {
        this.testProxyGeneratedClassesPath = path;
        return this;
    }

    public String testProxyGeneratedClassesPath() {
        return this.testProxyGeneratedClassesPath;
    }

    public Configuration usingTestProxyGeneratedSourcesPath(String path) {
        this.testProxyGeneratedSourcesPath = path;
        return this;
    }

    public String testProxyGeneratedSourcesPath() {
        return this.testProxyGeneratedSourcesPath;
    }

    public void startPlugins(World world, int pass) {
        this.load(pass);
        for (Plugin plugin : this.plugins) {
            if (plugin.pass() != pass) continue;
            plugin.start(world);
        }
    }

    public void load(int pass) {
        if (pass == 0) {
            if (this.properties != null) {
                if (this.mergeProperties) {
                    List<Plugin> plugins = this.loadPlugins(false);
                    plugins.addAll(this.loadPropertiesPlugins(this.properties, plugins));
                } else {
                    this.plugins.addAll(this.loadPropertiesPlugins(this.properties, new ArrayList<Plugin>()));
                }
            } else {
                this.plugins.addAll(this.loadPlugins(true));
            }
        }
    }

    private PluginConfiguration overrideConfiguration(Plugin plugin) {
        return this.configurationOverrides.get(plugin.configuration().getClass().getSimpleName());
    }

    private Configuration() {
        this(null, false);
    }

    private Configuration(Properties properties, boolean includeBaseLoad) {
        this.properties = properties;
        this.mergeProperties = includeBaseLoad;
        this.usingMainProxyGeneratedClassesPath("target/classes/").usingMainProxyGeneratedSourcesPath("target/generated-sources/").usingTestProxyGeneratedClassesPath("target/test-classes/").usingTestProxyGeneratedSourcesPath("target/generated-test-sources/");
    }

    private List<Plugin> loadPropertiesPlugins(Properties properties, List<Plugin> plugins) {
        HashSet<Plugin> unique = new HashSet<Plugin>(plugins);
        unique.addAll(new PluginLoader().loadEnabledPlugins(this, properties));
        for (Plugin plugin : unique) {
            plugin.configuration().buildWith(this, new PluginProperties(plugin.name(), properties));
        }
        return new ArrayList<Plugin>(unique);
    }

    private List<Plugin> loadPlugins(boolean build) {
        List<PluginFactory> pluginFactories = Arrays.asList(PooledCompletesPlugin::new, Slf4jLoggerPlugin::new, ManyToOneConcurrentArrayQueuePlugin::new, ConcurrentQueueMailboxPlugin::new, SharedRingBufferMailboxPlugin::new, CommonSupervisorsPlugin::new, DefaultSupervisorOverridePlugin::new, DirectoryEvictionPlugin::new);
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (PluginFactory pluginFactory : pluginFactories) {
            try {
                Plugin plugin = pluginFactory.build();
                PluginConfiguration pc = this.overrideConfiguration(plugin);
                boolean reallyBuild = pc == null ? build : false;
                Plugin configuredPlugin = plugin.with(pc);
                if (reallyBuild) {
                    configuredPlugin.configuration().build(this);
                }
                plugins.add(configuredPlugin);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot load plugin class: " + e.getMessage(), e);
            }
        }
        return plugins;
    }
}

