/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.ActorInstantiator;
import io.vlingo.xoom.actors.ActorProxyBase;
import io.vlingo.xoom.actors.ActorProxyStub;
import io.vlingo.xoom.actors.Logger;
import io.vlingo.xoom.actors.Stage;
import io.vlingo.xoom.actors.Supervisor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Definition {
    public static final List<Object> NoParameters = Collections.emptyList();
    private final String actorName;
    private final ActorInstantiator<? extends Actor> instantiator;
    private final Logger logger;
    private final String mailboxName;
    private final List<Object> parameters;
    private final Actor parent;
    private final Supervisor supervisor;
    private final Class<? extends Actor> type;
    final boolean evictable;

    public static Definition from(Stage stage, SerializationProxy proxy, Logger logger) {
        Actor parent = Optional.ofNullable(proxy.parent).map(p -> {
            ActorProxyBase.thunk(stage, proxy.parent);
            return stage.directory.actorOf(proxy.parent.address);
        }).orElse(null);
        return new Definition(proxy.type, proxy.instantiator, proxy.parameters, parent, proxy.mailboxName, proxy.actorName, logger, proxy.evictable);
    }

    private static Supervisor assignSupervisor(Actor parent) {
        if (parent instanceof Supervisor) {
            return parent.lifeCycle.environment.stage.actorAs(parent, Supervisor.class);
        }
        return null;
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator) {
        return Definition.has(type, instantiator, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, boolean evictable) {
        return new Definition(type, instantiator, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters) {
        return Definition.has(type, parameters, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, boolean evictable) {
        return new Definition(type, parameters, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Logger logger) {
        return Definition.has(type, instantiator, logger, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Logger logger, boolean evictable) {
        return new Definition(type, instantiator, logger, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Logger logger) {
        return Definition.has(type, parameters, logger, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Logger logger, boolean evictable) {
        return new Definition(type, parameters, logger, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String actorName) {
        return Definition.has(type, instantiator, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String actorName, boolean evictable) {
        return new Definition(type, instantiator, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, String actorName) {
        return Definition.has(type, parameters, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, String actorName, boolean evictable) {
        return new Definition(type, parameters, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String actorName, Logger logger) {
        return Definition.has(type, instantiator, actorName, logger, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String actorName, Logger logger, boolean evictable) {
        return new Definition(type, instantiator, actorName, logger, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, String actorName, Logger logger) {
        return Definition.has(type, parameters, actorName, logger, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, String actorName, Logger logger, boolean evictable) {
        return new Definition(type, parameters, actorName, logger, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String actorName) {
        return Definition.has(type, instantiator, parent, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String actorName, boolean evictable) {
        return new Definition(type, instantiator, parent, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Actor parent, String actorName) {
        return Definition.has(type, parameters, parent, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Actor parent, String actorName, boolean evictable) {
        return new Definition(type, parameters, parent, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String mailboxName, String actorName) {
        return Definition.has(type, instantiator, mailboxName, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String mailboxName, String actorName, boolean evictable) {
        return new Definition(type, instantiator, null, mailboxName, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, String mailboxName, String actorName) {
        return Definition.has(type, parameters, mailboxName, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, String mailboxName, String actorName, boolean evictable) {
        return new Definition(type, parameters, null, mailboxName, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName) {
        return Definition.has(type, instantiator, parent, mailboxName, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName, boolean evictable) {
        return new Definition(type, instantiator, parent, mailboxName, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName) {
        return Definition.has(type, parameters, parent, mailboxName, actorName, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName, boolean evictable) {
        return new Definition(type, parameters, parent, mailboxName, actorName, evictable);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName, Logger logger) {
        return Definition.has(type, instantiator, parent, mailboxName, actorName, logger, false);
    }

    public static Definition has(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName, Logger logger, boolean evictable) {
        return new Definition(type, instantiator, parent, mailboxName, actorName, logger, evictable);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName, Logger logger) {
        return Definition.has(type, parameters, parent, mailboxName, actorName, logger, false);
    }

    public static Definition has(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName, Logger logger, boolean evictable) {
        return new Definition(type, parameters, parent, mailboxName, actorName, logger, evictable);
    }

    public static List<Object> parameters(Object ... parameters) {
        return Arrays.asList(parameters);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator) {
        this(type, instantiator, false);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, boolean evictable) {
        this(type, instantiator, null, null, null, null, evictable);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Logger logger) {
        this(type, instantiator, logger, false);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Logger logger, boolean evictable) {
        this(type, instantiator, null, null, null, logger, evictable);
    }

    public Definition(Class<? extends Actor> actor, List<Object> parameters) {
        this(actor, parameters, false);
    }

    public Definition(Class<? extends Actor> actor, List<Object> parameters, boolean evictable) {
        this(actor, parameters, null, null, null, null, evictable);
    }

    public Definition(Class<? extends Actor> actor, List<Object> parameters, Logger logger) {
        this(actor, parameters, logger, false);
    }

    public Definition(Class<? extends Actor> actor, List<Object> parameters, Logger logger, boolean evictable) {
        this(actor, parameters, null, null, null, logger, evictable);
    }

    public Definition(Class<? extends Actor> actor, ActorInstantiator<? extends Actor> instantiator, String actorName, Logger logger) {
        this(actor, instantiator, actorName, logger, false);
    }

    public Definition(Class<? extends Actor> actor, ActorInstantiator<? extends Actor> instantiator, String actorName, Logger logger, boolean evictable) {
        this(actor, instantiator, null, null, actorName, logger, evictable);
    }

    public Definition(Class<? extends Actor> actor, List<Object> parameters, String actorName, Logger logger) {
        this(actor, parameters, actorName, logger, false);
    }

    public Definition(Class<? extends Actor> actor, List<Object> parameters, String actorName, Logger logger, boolean evictable) {
        this(actor, parameters, null, null, actorName, logger, evictable);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String actorName) {
        this(type, instantiator, actorName, false);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, String actorName, boolean evictable) {
        this(type, instantiator, null, null, actorName, null, evictable);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, String actorName) {
        this(type, parameters, actorName, false);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, String actorName, boolean evictable) {
        this(type, parameters, null, null, actorName, null, evictable);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String actorName) {
        this(type, instantiator, parent, actorName, false);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String actorName, boolean evictable) {
        this(type, instantiator, parent, null, actorName, null, evictable);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, Actor parent, String actorName) {
        this(type, parameters, parent, actorName, false);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, Actor parent, String actorName, boolean evictable) {
        this(type, parameters, parent, null, actorName, null, evictable);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName) {
        this(type, instantiator, parent, mailboxName, actorName, false);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName, boolean evictable) {
        this(type, instantiator, parent, mailboxName, actorName, null, evictable);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName) {
        this(type, parameters, parent, mailboxName, actorName, false);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName, boolean evictable) {
        this(type, parameters, parent, mailboxName, actorName, null, evictable);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName, Logger logger) {
        this(type, parameters, parent, mailboxName, actorName, logger, false);
    }

    public Definition(Class<? extends Actor> type, List<Object> parameters, Actor parent, String mailboxName, String actorName, Logger logger, boolean evictable) {
        this.type = type;
        this.instantiator = null;
        this.parameters = parameters;
        this.parent = parent;
        this.mailboxName = mailboxName;
        this.actorName = actorName;
        this.supervisor = Definition.assignSupervisor(parent);
        this.logger = logger;
        this.evictable = evictable;
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName, Logger logger) {
        this(type, instantiator, parent, mailboxName, actorName, logger, false);
    }

    public Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, Actor parent, String mailboxName, String actorName, Logger logger, boolean evictable) {
        this(type, instantiator, NoParameters, parent, mailboxName, actorName, logger, evictable);
    }

    private Definition(Class<? extends Actor> type, ActorInstantiator<? extends Actor> instantiator, List<Object> parameters, Actor parent, String mailboxName, String actorName, Logger logger, boolean evictable) {
        this.type = type;
        this.instantiator = instantiator;
        this.parameters = parameters;
        this.parent = parent;
        this.mailboxName = mailboxName;
        this.actorName = actorName;
        this.supervisor = Definition.assignSupervisor(parent);
        this.logger = logger;
        this.evictable = evictable;
    }

    public String actorName() {
        return this.actorName;
    }

    public boolean hasInstantiator() {
        return this.instantiator != null;
    }

    public ActorInstantiator<? extends Actor> instantiator() {
        return this.instantiator;
    }

    public Logger loggerOr(Logger defaultLogger) {
        return this.logger != null ? this.logger : defaultLogger;
    }

    public String mailboxName() {
        return this.mailboxName;
    }

    public List<Object> parameters() {
        return new ArrayList<Object>(this.internalParameters());
    }

    public Actor parent() {
        return this.parent;
    }

    public Actor parentOr(Actor defaultParent) {
        return this.parent != null ? this.parent : defaultParent;
    }

    public Supervisor supervisor() {
        return this.supervisor;
    }

    public Class<? extends Actor> type() {
        return this.type;
    }

    List<Object> internalParameters() {
        return this.parameters;
    }

    public static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 2654451856010534929L;
        public final String actorName;
        public final ActorInstantiator<? extends Actor> instantiator;
        public final String mailboxName;
        public final List<Object> parameters;
        public final ActorProxyStub<?> parent;
        public final Class<? extends Actor> type;
        public final boolean evictable;

        public static SerializationProxy from(Definition definition) {
            return new SerializationProxy(definition.actorName, definition.instantiator, definition.mailboxName, definition.parameters, Optional.ofNullable(definition.parent).map(ActorProxyStub::new).orElse(null), definition.type, definition.evictable);
        }

        public SerializationProxy(String actorName, ActorInstantiator<? extends Actor> instantiator, String mailboxName, List<Object> parameters, ActorProxyStub<?> parent, Class<? extends Actor> type, boolean evictable) {
            this.actorName = actorName;
            this.instantiator = instantiator;
            this.mailboxName = mailboxName;
            this.parameters = parameters;
            this.parent = parent;
            this.type = type;
            this.evictable = evictable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializationProxy that = (SerializationProxy)o;
            return Objects.equals(this.actorName, that.actorName) && Objects.equals(this.instantiator, that.instantiator) && Objects.equals(this.mailboxName, that.mailboxName) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.parent, that.parent) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.actorName, this.instantiator, this.mailboxName, this.parameters, this.parent, this.type);
        }

        public String toString() {
            return String.format("Definition(actorName='%s', instantiator='%s', mailboxName='%s', parameters='%s', parent='%s', type='%s')", this.actorName, this.instantiator, this.mailboxName, this.parameters, this.parent, this.type);
        }
    }
}

