/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class Directory {
    private static final int DefaultStageBuckets = 32;
    private static final int DefaultStageInitialCapacity = 32;
    private final Address none;
    private final int buckets;
    private final int initialCapacity;
    private final float loadFactor = 0.75f;
    private final int concurrencyLevel = 16;
    private final Map<Address, Actor>[] maps;

    Directory(Address none) {
        this(none, 32, 32);
    }

    Directory(Address none, int buckets, int initialCapacity) {
        this.none = none;
        this.buckets = buckets;
        this.initialCapacity = initialCapacity;
        this.maps = this.build();
    }

    Actor actorOf(Address address) {
        return this.maps[this.mapIndex(address)].get(address);
    }

    int count() {
        int count = 0;
        for (Map<Address, Actor> map : this.maps) {
            count += map.size();
        }
        return count;
    }

    void dump(Logger logger) {
        if (logger.isEnabled()) {
            for (Map<Address, Actor> map : this.maps) {
                for (Actor actor : map.values()) {
                    Address address = actor.address();
                    Address parent = actor.lifeCycle.environment.parent == null ? this.none : actor.lifeCycle.environment.parent.address();
                    logger.debug("DIR: DUMP: ACTOR: " + address + " PARENT: " + parent + " TYPE: " + actor.getClass());
                }
            }
        }
    }

    boolean isRegistered(Address address) {
        return this.maps[this.mapIndex(address)].containsKey(address);
    }

    void register(Address address, Actor actor) {
        if (this.isRegistered(address)) {
            throw new ActorAddressAlreadyRegistered(actor.getClass(), address);
        }
        this.maps[this.mapIndex(address)].put(address, actor);
    }

    Actor remove(Address address) {
        return this.maps[this.mapIndex(address)].remove(address);
    }

    Collection<Actor> evictionCandidates(long thresholdMillis) {
        return Arrays.stream(this.maps).flatMap(m -> m.values().stream()).filter(a -> a.lifeCycle.evictable.isStale(thresholdMillis) && a.lifeCycle.environment.mailbox.pendingMessages() == 0).collect(Collectors.toCollection(ArrayList::new));
    }

    Collection<Address> addresses() {
        return Arrays.stream(this.maps).flatMap(m -> m.keySet().stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    private Map<Address, Actor>[] build() {
        ConcurrentHashMap[] tempMaps = new ConcurrentHashMap[this.buckets];
        for (int idx = 0; idx < tempMaps.length; ++idx) {
            tempMaps[idx] = new ConcurrentHashMap(this.initialCapacity, 0.75f, 16);
        }
        return tempMaps;
    }

    private int mapIndex(Address address) {
        return Math.abs(address.hashCode() % this.maps.length);
    }

    public static final class ActorAddressAlreadyRegistered
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public ActorAddressAlreadyRegistered(Class<?> type, Address address) {
            super(String.format("Failed to register Actor of type %s. Address is already registered: %s", type, address));
        }
    }
}

