/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Directory;
import io.vlingo.xoom.actors.DirectoryEvictionConfiguration;
import io.vlingo.xoom.common.Scheduled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DirectoryEvictor
extends Actor
implements Scheduled<Object> {
    private final DirectoryEvictionConfiguration config;
    private final Directory directory;

    public DirectoryEvictor(Directory directory) {
        this(new DirectoryEvictionConfiguration(), directory);
    }

    public DirectoryEvictor(DirectoryEvictionConfiguration config, Directory directory) {
        this.config = config;
        this.directory = directory;
        this.logger().debug("Created with config: {}", config);
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object o) {
        this.logger().debug("Started eviction routine");
        float fillRatio = (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory();
        if (fillRatio >= this.config.fillRatioHigh()) {
            this.logger().debug("Memory fill ratio {} exceeding watermark ({})", Float.valueOf(fillRatio), Float.valueOf(this.config.fillRatioHigh()));
            Collection evicted = this.directory.evictionCandidates(this.config.lruThresholdMillis()).stream().flatMap(actor -> {
                if (actor.lifeCycle.evictable.stop(this.config.lruThresholdMillis())) {
                    return Stream.of(actor.address());
                }
                return Stream.empty();
            }).collect(Collectors.toCollection(ArrayList::new));
            this.logger().debug("Evicted {} actors :: {}", evicted.size(), evicted);
        } else {
            this.logger().debug("Memory fill ratio {} was below watermark ({})", Float.valueOf(fillRatio), Float.valueOf(this.config.fillRatioHigh()));
        }
    }
}

