/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.Directory;
import io.vlingo.xoom.actors.DirectoryScanner;
import io.vlingo.xoom.common.Completes;
import java.util.Optional;

public class DirectoryScannerActor
extends Actor
implements DirectoryScanner {
    private final Directory directory;

    public DirectoryScannerActor(Directory directory) {
        this.directory = directory;
    }

    @Override
    public <T> Completes<T> actorOf(Class<T> protocol, Address address) {
        return this.completes().with(this.internalActorOf(protocol, address));
    }

    @Override
    public <T> Completes<T> actorOf(Class<T> protocol, Address address, Definition definition) {
        T typed = this.internalActorOf(protocol, address);
        if (typed == null) {
            typed = this.stage().actorFor(protocol, definition, address);
        }
        return this.completes().with(typed);
    }

    @Override
    public <T> Completes<Optional<T>> maybeActorOf(Class<T> protocol, Address address) {
        T typed = this.internalActorOf(protocol, address);
        Optional maybe = typed == null ? Optional.empty() : Optional.of(typed);
        return this.completes().with(maybe);
    }

    private <T> T internalActorOf(Class<T> protocol, Address address) {
        Actor actor = this.directory.actorOf(address);
        try {
            if (actor != null) {
                return this.stage().actorAs(actor, protocol);
            }
            this.logger().debug("Actor with address: " + address + " not found; protocol is: " + protocol.getName());
        }
        catch (Exception e) {
            this.logger().error("Error providing protocol: " + protocol.getName() + " for actor with address: " + address, e);
        }
        return null;
    }
}

