/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.CompletesEventually;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.FailureMark;
import io.vlingo.xoom.actors.Logger;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.ResultReturns;
import io.vlingo.xoom.actors.Stage;
import io.vlingo.xoom.actors.Supervisor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class Environment {
    final Address address;
    final ConcurrentLinkedQueue<Actor> children;
    Address completesEventuallyAddress;
    final Definition definition;
    final FailureMark failureMark;
    final Logger logger;
    final Mailbox mailbox;
    final Supervisor maybeSupervisor;
    final Actor parent;
    final Map<String, Object> proxyCache;
    final Stage stage;
    private final AtomicBoolean secured;
    private final AtomicBoolean stopped;
    private Class<?>[] stowageOverrides;

    public static Environment of(Actor actor) {
        return actor.lifeCycle.environment;
    }

    public int pendingMessages() {
        return this.mailbox.pendingMessages();
    }

    protected Environment(Stage stage, Address address, Definition definition, Actor parent, Mailbox mailbox, Supervisor maybeSupervisor, Logger logger) {
        assert (stage != null);
        this.stage = stage;
        assert (address != null);
        this.address = address;
        assert (definition != null);
        this.definition = definition;
        assert (address.id() == Long.MAX_VALUE || parent != null);
        this.parent = parent;
        assert (mailbox != null);
        this.mailbox = mailbox;
        this.maybeSupervisor = maybeSupervisor;
        this.failureMark = new FailureMark();
        this.logger = logger;
        this.children = new ConcurrentLinkedQueue();
        this.proxyCache = new HashMap<String, Object>(1);
        this.stowageOverrides = null;
        this.secured = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }

    void addChild(Actor child) {
        this.children.add(child);
    }

    void removeChild(Actor child) {
        this.children.remove(child);
    }

    CompletesEventually completesEventually(ResultReturns result) {
        if (this.completesEventuallyAddress == null) {
            CompletesEventually completesEventually = this.stage.world().completesFor(result.clientReturns());
            this.completesEventuallyAddress = completesEventually.address();
            return completesEventually;
        }
        return this.stage.world().completesFor(this.completesEventuallyAddress, result.clientReturns());
    }

    <T> void cacheProxy(T proxy) {
        this.proxyCache.put(proxy.getClass().getName(), proxy);
    }

    <T> T lookUpProxy(Class<T> protocol) {
        return (T)this.proxyCache.get(protocol.getName());
    }

    boolean isSecured() {
        return this.secured.get();
    }

    void setSecured() {
        this.secured.set(true);
    }

    boolean isStopped() {
        return this.stopped.get();
    }

    void removeFromParent(Actor actor) {
        if (this.parent != null) {
            this.parent.lifeCycle.environment.removeChild(actor);
        }
    }

    void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.stopChildren();
            this.mailbox.close();
        }
    }

    boolean isStowageOverride(Class<?> protocol) {
        if (this.stowageOverrides != null) {
            for (Class<?> override : this.stowageOverrides) {
                if (override != protocol) continue;
                return true;
            }
        }
        return false;
    }

    void stowageOverrides(Class<?> ... overrides) {
        this.stowageOverrides = overrides;
    }

    private void stopChildren() {
        this.children.forEach(Actor::stop);
        this.children.clear();
    }
}

