/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Stoppable;

final class Evictable {
    final Actor actor;
    private long activeOn;

    Evictable(Actor actor) {
        this.actor = actor;
        this.activeOn = System.currentTimeMillis();
    }

    void receivedMessage() {
        this.activeOn(System.currentTimeMillis());
    }

    void activeOn(long activeOn) {
        this.activeOn = activeOn;
    }

    boolean stop(long thresholdMillis) {
        return this.stop(System.currentTimeMillis(), thresholdMillis);
    }

    boolean stop(long referenceMillis, long thresholdMillis) {
        if (!this.actor.definition().evictable) {
            return false;
        }
        int pendingMessageCount = this.actor.lifeCycle.environment.mailbox.pendingMessages();
        if (this.isStale(referenceMillis, thresholdMillis)) {
            if (pendingMessageCount == 0) {
                this.actor.selfAs(Stoppable.class).stop();
                return true;
            }
            this.actor.logger().warn("Inactive Actor at {} failed to evict because it has {} undelivered messages in its mailbox", this.actor.address(), pendingMessageCount);
        }
        return false;
    }

    boolean isStale(long thresholdMillis) {
        return this.isStale(System.currentTimeMillis(), thresholdMillis);
    }

    boolean isStale(long referenceMillis, long thresholdMillis) {
        return this.activeOn < referenceMillis - thresholdMillis;
    }
}

