/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FailureMark {
    private AtomicLong startOfPeriod;
    private AtomicInteger timedIntensity;

    public FailureMark() {
        this.reset();
    }

    boolean failedWithExcessiveFailures(long period, int intensity) {
        boolean periodExceeded;
        if (intensity == -1) {
            return false;
        }
        if (intensity == 1) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (this.startOfPeriod.get() == 0L) {
            this.startOfPeriod.set(currentTime);
            this.timedIntensity.set(1);
        } else {
            this.timedIntensity.incrementAndGet();
        }
        boolean bl = periodExceeded = this.startOfPeriod.get() - currentTime >= period;
        if (this.timedIntensity.get() > intensity && !periodExceeded) {
            return true;
        }
        if (periodExceeded) {
            this.reset();
            return this.failedWithExcessiveFailures(period, intensity);
        }
        return false;
    }

    void reset() {
        this.startOfPeriod = new AtomicLong(0L);
        this.timedIntensity = new AtomicInteger(0);
    }
}

