/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.Environment;
import io.vlingo.xoom.actors.Evictable;
import io.vlingo.xoom.actors.LocalMessage;
import io.vlingo.xoom.actors.StageSupervisedActor;
import io.vlingo.xoom.actors.Startable;
import io.vlingo.xoom.actors.Stoppable;
import io.vlingo.xoom.actors.Supervisor;
import io.vlingo.xoom.common.SerializableConsumer;
import java.io.Serializable;

final class LifeCycle {
    final Environment environment;
    final Evictable evictable;

    LifeCycle(Environment environment, Evictable evictable) {
        this.environment = environment;
        this.evictable = evictable;
    }

    public int hashCode() {
        return this.address().hashCode();
    }

    Address address() {
        return this.environment.address;
    }

    Definition definition() {
        if (this.environment.isSecured()) {
            throw new IllegalStateException("A secured actor cannot provide its definition.");
        }
        return this.environment.definition;
    }

    <T> T lookUpProxy(Class<T> protocol) {
        return this.environment.lookUpProxy(protocol);
    }

    boolean isSecured() {
        return this.environment.isSecured();
    }

    void secure() {
        this.environment.setSecured();
    }

    boolean isStopped() {
        return this.environment.isStopped();
    }

    void stop(Actor actor) {
        this.environment.stop();
        this.environment.removeFromParent(actor);
        this.afterStop(actor);
    }

    void afterStop(Actor actor) {
        try {
            actor.afterStop();
        }
        catch (Throwable t) {
            this.environment.logger.error("XOOM: Actor afterStop() failed: " + t.getMessage(), t);
            this.environment.stage.handleFailureOf(new StageSupervisedActor(Stoppable.class, actor, t));
        }
    }

    void beforeStart(Actor actor) {
        try {
            actor.beforeStart();
        }
        catch (Throwable t) {
            this.environment.logger.error("XOOM: Actor beforeStart() failed: " + t.getMessage());
            this.environment.stage.handleFailureOf(new StageSupervisedActor(Startable.class, actor, t));
        }
    }

    void afterRestart(Actor actor, Throwable throwable, Class<?> protocol) {
        try {
            actor.afterRestart(throwable);
        }
        catch (Throwable t) {
            this.environment.logger.error("XOOM: Actor beforeStart() failed: " + t.getMessage());
            this.environment.stage.handleFailureOf(new StageSupervisedActor(Startable.class, actor, t));
        }
    }

    void beforeRestart(Actor actor, Throwable reason, Class<?> protocol) {
        try {
            actor.beforeRestart(reason);
        }
        catch (Throwable t) {
            this.environment.logger.error("XOOM: Actor beforeRestart() failed: " + t.getMessage());
            this.environment.stage.handleFailureOf(new StageSupervisedActor(protocol, actor, t));
        }
    }

    void beforeResume(Actor actor, Throwable reason, Class<?> protocol) {
        try {
            actor.beforeResume(reason);
        }
        catch (Throwable t) {
            this.environment.logger.error("XOOM: Actor beforeResume() failed: " + t.getMessage());
            this.environment.stage.handleFailureOf(new StageSupervisedActor(protocol, actor, t));
        }
    }

    void sendStart(Actor targetActor) {
        try {
            SerializableConsumer & Serializable consumer = (SerializableConsumer & Serializable)actor -> actor.start();
            if (!this.environment.mailbox.isPreallocated()) {
                LocalMessage<Startable> message = new LocalMessage<Startable>(targetActor, Startable.class, consumer, "start()");
                this.environment.mailbox.send(message);
            } else {
                this.environment.mailbox.send(targetActor, Startable.class, consumer, null, "start()");
            }
        }
        catch (Throwable t) {
            this.environment.logger.error("XOOM: Actor start() failed: " + t.getMessage());
            this.environment.stage.handleFailureOf(new StageSupervisedActor(Startable.class, targetActor, t));
        }
    }

    void resume() {
        this.environment.mailbox.resume("#exceptional");
    }

    boolean isSuspended() {
        return this.environment.mailbox.isSuspended();
    }

    void suspend() {
        this.environment.mailbox.suspendExceptFor("#exceptional", Stoppable.class);
    }

    void suspendForStop() {
        this.environment.mailbox.suspendExceptFor("#stopping", Stoppable.class);
    }

    Supervisor supervisor(Class<?> protocol) {
        Supervisor supervisor = this.environment.maybeSupervisor;
        if (supervisor == null) {
            supervisor = this.environment.stage.commonSupervisorOr(protocol, this.environment.stage.world().defaultSupervisor());
        }
        return supervisor;
    }
}

