/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.DeadLetter;
import io.vlingo.xoom.actors.DeadLetters;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.Returns;
import io.vlingo.xoom.actors.StageSupervisedActor;
import io.vlingo.xoom.common.SerializableConsumer;

public class LocalMessage<T>
implements Message {
    Actor actor;
    Returns<Object> returns;
    SerializableConsumer<T> consumer;
    Class<T> protocol;
    String representation;

    public LocalMessage(Actor actor, Class<T> protocol, SerializableConsumer<T> consumer, Returns<?> returns, String representation) {
        this.actor = actor;
        this.consumer = consumer;
        this.protocol = protocol;
        this.representation = representation;
        this.returns = returns;
    }

    public LocalMessage(Actor actor, Class<T> protocol, SerializableConsumer<T> consumer, String representation) {
        this(actor, protocol, consumer, null, representation);
    }

    public LocalMessage(LocalMessage<T> message) {
        this(message.actor, message.protocol, message.consumer, message.returns, message.representation);
    }

    public LocalMessage(Mailbox mailbox) {
        assert (mailbox.isPreallocated());
    }

    @Override
    public Actor actor() {
        return this.actor;
    }

    public SerializableConsumer<T> consumer() {
        return this.consumer;
    }

    public Returns<?> returns() {
        return this.returns;
    }

    @Override
    public void deliver() {
        this.internalDeliver(this);
    }

    @Override
    public Class<?> protocol() {
        return this.protocol;
    }

    @Override
    public String representation() {
        return this.representation;
    }

    @Override
    public boolean isStowed() {
        return false;
    }

    @Override
    public void set(Actor actor, Class<?> protocol, SerializableConsumer<?> consumer, Returns<?> returns, String representation) {
        this.actor = actor;
        this.consumer = consumer;
        this.protocol = protocol;
        this.representation = representation;
        this.returns = returns;
    }

    public String toString() {
        return "LocalMessage[" + this.representation() + "]";
    }

    private void deadLetter() {
        DeadLetter deadLetter = new DeadLetter(this.actor, this.representation);
        DeadLetters deadLetters = this.actor.deadLetters();
        if (deadLetters != null) {
            deadLetters.failedDelivery(deadLetter);
        } else {
            this.actor.logger().warn("XOOM: MISSING DEAD LETTERS FOR: " + deadLetter);
        }
    }

    private void internalDeliver(Message message) {
        if (this.actor.isStopped()) {
            this.deadLetter();
        } else {
            try {
                this.actor.returns.reset(this.returns);
                this.consumer.accept((Object)this.actor);
                this.actor.lifeCycle.evictable.receivedMessage();
                if (this.actor.returns.__internal__outcomeSet) {
                    this.actor.lifeCycle.environment.completesEventually(this.actor.returns).with(this.actor.returns.__internal__outcome);
                }
            }
            catch (Throwable t) {
                this.actor.stage().handleFailureOf(new StageSupervisedActor(this.protocol, this.actor, t));
            }
        }
    }
}

