/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.LocalMessage;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.Returns;
import io.vlingo.xoom.common.SerializableConsumer;

public interface Mailbox
extends Runnable {
    public static final String Exceptional = "#exceptional";
    public static final String Paused = "#paused";
    public static final String Stopping = "#stopping";

    public void close();

    public boolean isClosed();

    public boolean isDelivering();

    public int concurrencyCapacity();

    public void resume(String var1);

    public void send(Message var1);

    public void suspendExceptFor(String var1, Class<?> ... var2);

    public boolean isSuspended();

    default public boolean isSuspendedFor(String name) {
        throw new UnsupportedOperationException("Mailbox implementation does not support this operation.");
    }

    public Message receive();

    public int pendingMessages();

    default public boolean isPreallocated() {
        return false;
    }

    default public void send(Actor actor, Class<?> protocol, SerializableConsumer<?> consumer, Returns<?> returns, String representation) {
        this.send(new LocalMessage(actor, protocol, consumer, returns, representation));
    }
}

