/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import java.util.Optional;
import java.util.function.Function;

public class Properties {
    public static final java.util.Properties properties = new java.util.Properties();
    private static final String propertiesFile = "/xoom-actors.properties";

    public static long getLong(String key, long defaultValue) {
        return Properties.get(key, Long::parseLong, defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        return Properties.get(key, Float::parseFloat, Float.valueOf(defaultValue)).floatValue();
    }

    private static <T> T get(String key, Function<String, T> parse, T defaultValue) {
        return (T)Optional.ofNullable(properties.getProperty(key)).flatMap(value -> {
            try {
                return Optional.of(parse.apply((String)value));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }).orElse(defaultValue);
    }

    static {
        try {
            properties.load(Properties.class.getResourceAsStream(propertiesFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

