/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Stoppable;
import io.vlingo.xoom.actors.Supervised;
import io.vlingo.xoom.actors.SupervisionStrategy;
import io.vlingo.xoom.actors.Supervisor;

public class PublicRootActor
extends Actor
implements Stoppable,
Supervisor {
    private final Supervisor self;
    private final SupervisionStrategy supervisionStrategy = new SupervisionStrategy(){

        @Override
        public int intensity() {
            return -1;
        }

        @Override
        public long period() {
            return Long.MAX_VALUE;
        }

        @Override
        public SupervisionStrategy.Scope scope() {
            return SupervisionStrategy.Scope.One;
        }
    };

    public PublicRootActor() {
        this.self = this.selfAs(Supervisor.class);
    }

    @Override
    protected void beforeStart() {
        super.beforeStart();
        this.stage().world().setDefaultParent(this);
        this.stage().world().setPublicRoot(this.selfAs(Stoppable.class));
    }

    @Override
    protected void afterStop() {
        this.stage().world().setDefaultParent(null);
        this.stage().world().setPublicRoot(null);
        super.afterStop();
    }

    @Override
    public void inform(Throwable throwable, Supervised supervised) {
        this.logger().error("PublicRootActor: Failure of: " + supervised.address() + " because: " + throwable.getMessage() + " Action: Restarting.", throwable);
        supervised.restartWithin(this.supervisionStrategy.period(), this.supervisionStrategy.intensity(), this.supervisionStrategy.scope());
    }

    @Override
    public SupervisionStrategy supervisionStrategy() {
        return this.supervisionStrategy;
    }

    @Override
    public Supervisor supervisor() {
        return this.self;
    }
}

