/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Routee;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Routing<P> {
    private final List<Routee<P>> routees;

    public static <T> Routing<T> with(Routee<T> routee) {
        if (routee == null) {
            throw new IllegalArgumentException("routee may not be null");
        }
        return new Routing(Arrays.asList(routee));
    }

    public static <T> Routing<T> with(List<Routee<T>> routees) {
        if (routees == null || routees.isEmpty()) {
            throw new IllegalArgumentException("routees may not be null or empty");
        }
        return new Routing(routees);
    }

    public static <T> Routing<T> with(Set<Routee<T>> routees) {
        if (routees == null || routees.isEmpty()) {
            throw new IllegalArgumentException("routees may not be null or empty");
        }
        return new Routing(routees);
    }

    Routing() {
        this.routees = new ArrayList<Routee<P>>();
    }

    Routing(List<Routee<P>> routees) {
        this.routees = routees;
    }

    Routing(Set<Routee<P>> routees) {
        this(new ArrayList<Routee<P>>(routees));
    }

    public Routee<P> first() {
        return this.routees.get(0);
    }

    public List<Routee<P>> routees() {
        return Collections.unmodifiableList(this.routees);
    }

    public boolean isEmpty() {
        return this.routees.isEmpty();
    }

    public String toString() {
        return "Routing[routees=" + Arrays.toString(this.routees.toArray()) + "]";
    }

    public void validate() {
        if (this.routees.isEmpty()) {
            throw new IllegalStateException("routees may not be empty");
        }
    }
}

