/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.ActorFactory;
import io.vlingo.xoom.actors.ActorInstantiator;
import io.vlingo.xoom.actors.ActorProxy;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.AddressFactory;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.Directory;
import io.vlingo.xoom.actors.DirectoryEvictionConfiguration;
import io.vlingo.xoom.actors.DirectoryEvictor;
import io.vlingo.xoom.actors.DirectoryScanner;
import io.vlingo.xoom.actors.DirectoryScannerActor;
import io.vlingo.xoom.actors.Logger;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Properties;
import io.vlingo.xoom.actors.Protocols;
import io.vlingo.xoom.actors.Startable;
import io.vlingo.xoom.actors.Stoppable;
import io.vlingo.xoom.actors.Supervised;
import io.vlingo.xoom.actors.Supervisor;
import io.vlingo.xoom.actors.World;
import io.vlingo.xoom.actors.testkit.TestActor;
import io.vlingo.xoom.common.Completes;
import io.vlingo.xoom.common.Scheduled;
import io.vlingo.xoom.common.Scheduler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class Stage
implements Stoppable {
    private final AddressFactory addressFactory;
    private final Map<Class<?>, Supervisor> commonSupervisors;
    protected final Directory directory;
    private DirectoryScanner directoryScanner;
    private final String name;
    private final Scheduler scheduler;
    private AtomicBoolean stopped;
    protected final World world;

    public Stage(World world, AddressFactory addressFactory, String name) {
        this(world, addressFactory, name, 32, 32);
    }

    public Stage(World world, AddressFactory addressFactory, String name, int directoryBuckets, int directoryInitialCapacity) {
        this.world = world;
        this.addressFactory = addressFactory;
        this.name = name;
        this.directory = new Directory(addressFactory.none(), directoryBuckets, directoryInitialCapacity);
        this.commonSupervisors = new HashMap();
        this.scheduler = new Scheduler();
        this.stopped = new AtomicBoolean(false);
    }

    public <T> T actorAs(Actor actor, Class<T> protocol) {
        return this.actorProxyFor(protocol, actor, actor.lifeCycle.environment.mailbox);
    }

    public <T, A extends Actor> T actorFor(Class<T> protocol, Class<? extends Actor> type, ActorInstantiator<A> instantiator) {
        return this.actorFor(protocol, Definition.has(type, instantiator));
    }

    public <T> T actorFor(Class<T> protocol, Class<? extends Actor> type, Object ... parameters) {
        return this.actorFor(protocol, Definition.has(type, Arrays.asList(parameters)));
    }

    public <T> T actorFor(Class<T> protocol, Definition definition) {
        return this.actorFor(protocol, definition, definition.parentOr(this.world.defaultParent()), definition.supervisor(), definition.loggerOr(this.world.defaultLogger()));
    }

    public <T> T actorFor(Class<T> protocol, Definition definition, Address address) {
        Address actorAddress = this.allocateAddress(definition, address);
        Mailbox actorMailbox = this.allocateMailbox(definition, actorAddress, null);
        ActorProtocolActor<T> actor = this.actorProtocolFor(protocol, definition, definition.parentOr(this.world.defaultParent()), actorAddress, actorMailbox, definition.supervisor(), definition.loggerOr(this.world.defaultLogger()));
        return actor.protocolActor();
    }

    public <T> T actorFor(Class<T> protocol, Definition definition, Logger logger) {
        return this.actorFor(protocol, definition, definition.parentOr(this.world.defaultParent()), definition.supervisor(), logger);
    }

    public <T> T actorFor(Class<T> protocol, Definition definition, Address address, Logger logger) {
        Address actorAddress = this.allocateAddress(definition, address);
        Mailbox actorMailbox = this.allocateMailbox(definition, actorAddress, null);
        ActorProtocolActor<T> actor = this.actorProtocolFor(protocol, definition, definition.parentOr(this.world.defaultParent()), actorAddress, actorMailbox, definition.supervisor(), logger);
        return actor.protocolActor();
    }

    public Protocols actorFor(Class<?>[] protocols, Definition definition) {
        ActorProtocolActor<Object>[] all = this.actorProtocolFor(protocols, definition, definition.parentOr(this.world.defaultParent()), definition.supervisor(), definition.loggerOr(this.world.defaultLogger()));
        return new Protocols(ActorProtocolActor.toActors(all));
    }

    public Protocols actorFor(Class<?>[] protocols, Definition definition, Actor parent, Supervisor maybeSupervisor, Logger logger) {
        ActorProtocolActor<Object>[] all = this.actorProtocolFor(protocols, definition, parent, maybeSupervisor, logger);
        return new Protocols(ActorProtocolActor.toActors(all));
    }

    public Protocols actorFor(Class<?>[] protocols, Class<? extends Actor> type, Object ... parameters) {
        return this.actorFor(protocols, Definition.has(type, Arrays.asList(parameters)));
    }

    public <T> Completes<T> actorOf(Class<T> protocol, Address address) {
        return this.directoryScanner.actorOf(protocol, address).andThen(null, proxy -> proxy);
    }

    public <T, A extends Actor> Completes<T> actorOf(Class<T> protocol, Address address, Class<? extends Actor> type, ActorInstantiator<A> instantiator) {
        return this.actorOf(protocol, address, Definition.has(type, instantiator));
    }

    public <T> Completes<T> actorOf(Class<T> protocol, Address address, Class<? extends Actor> type, Object ... parameters) {
        return this.actorOf(protocol, address, Definition.has(type, Arrays.asList(parameters)));
    }

    public <T> Completes<T> actorOf(Class<T> protocol, Address address, Definition definition) {
        return this.directoryScanner.actorOf(protocol, address, definition);
    }

    public AddressFactory addressFactory() {
        return this.addressFactory;
    }

    public <T> Completes<Optional<T>> maybeActorOf(Class<T> protocol, Address address) {
        return this.directoryScanner.maybeActorOf(protocol, address).andThen(proxy -> proxy);
    }

    public final <T> TestActor<T> testActorFor(Class<T> protocol, Class<? extends Actor> type, Object ... parameters) {
        return this.testActorFor(protocol, Definition.has(type, Arrays.asList(parameters), "testerMailbox", this.addressFactory().unique().name()));
    }

    public final <T> TestActor<T> testActorFor(Class<T> protocol, Definition definition) {
        Definition redefinition = this.redefinitionWithMailboxName(definition, "testerMailbox");
        try {
            return this.actorProtocolFor(protocol, redefinition, definition.parentOr(this.world.defaultParent()), null, null, definition.supervisor(), definition.loggerOr(this.world.defaultLogger())).toTestActor();
        }
        catch (Exception e) {
            this.world.defaultLogger().error("XOOM: FAILED: " + e.getMessage(), e);
            e.printStackTrace();
            return null;
        }
    }

    public final Protocols testActorFor(Class<?>[] protocols, Definition definition) {
        Definition redefinition = this.redefinitionWithMailboxName(definition, "testerMailbox");
        ActorProtocolActor<Object>[] all = this.actorProtocolFor(protocols, redefinition, definition.parentOr(this.world.defaultParent()), null, null, definition.supervisor(), definition.loggerOr(this.world.defaultLogger()));
        return new Protocols(ActorProtocolActor.toTestActors(all));
    }

    public int count() {
        return this.directory.count();
    }

    public void dump() {
        Logger logger = this.world.defaultLogger();
        if (logger.isEnabled()) {
            logger.debug("STAGE: " + this.name);
            this.directory.dump(logger);
        }
    }

    public String name() {
        return this.name;
    }

    public void registerCommonSupervisor(Class<?> protocol, Supervisor common) {
        this.commonSupervisors.put(protocol, common);
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public void conclude() {
        this.stop();
    }

    @Override
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        this.sweep();
        int retries = 0;
        while (this.count() > 1 && ++retries < 10) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        this.scheduler.close();
    }

    public World world() {
        return this.world;
    }

    protected <T> T actorFor(Class<T> protocol, Definition definition, Actor parent, Supervisor maybeSupervisor, Logger logger) {
        ActorProtocolActor<T> actor = this.actorProtocolFor(protocol, definition, parent, null, null, maybeSupervisor, logger);
        return actor.protocolActor();
    }

    protected ActorProtocolActor<Object>[] actorProtocolFor(Class<?>[] protocols, Definition definition, Actor parent, Supervisor maybeSupervisor, Logger logger) {
        this.assertProtocolCompliance(protocols);
        return this.actorProtocolFor(protocols, definition, parent, null, null, maybeSupervisor, logger);
    }

    protected <T> ActorProtocolActor<T> actorProtocolFor(Class<T> protocol, Definition definition, Actor parent, Address maybeAddress, Mailbox maybeMailbox, Supervisor maybeSupervisor, Logger logger) {
        this.assertProtocolCompliance(protocol);
        try {
            Actor actor = this.createRawActor(definition, parent, maybeAddress, maybeMailbox, maybeSupervisor, logger);
            T protocolActor = this.actorProxyFor(protocol, actor, actor.lifeCycle.environment.mailbox);
            return new ActorProtocolActor<T>(actor, protocolActor);
        }
        catch (Directory.ActorAddressAlreadyRegistered e) {
            throw e;
        }
        catch (Exception e) {
            this.world.defaultLogger().error("XOOM: FAILED: " + e.getMessage(), e);
            return null;
        }
    }

    protected ActorProtocolActor<Object>[] actorProtocolFor(Class<?>[] protocols, Definition definition, Actor parent, Address maybeAddress, Mailbox maybeMailbox, Supervisor maybeSupervisor, Logger logger) {
        try {
            Actor actor = this.createRawActor(definition, parent, maybeAddress, maybeMailbox, maybeSupervisor, logger);
            Object[] protocolActors = this.actorProxyFor(protocols, actor, actor.lifeCycle.environment.mailbox);
            return ActorProtocolActor.allOf(protocolActors, actor);
        }
        catch (Exception e) {
            this.world.defaultLogger().error("XOOM: FAILED: " + e.getMessage(), e);
            return null;
        }
    }

    final <T> T actorProxyFor(Class<T> protocol, Actor actor, Mailbox mailbox) {
        return ActorProxy.createFor(protocol, actor, mailbox);
    }

    final Object[] actorProxyFor(Class<?>[] protocols, Actor actor, Mailbox mailbox) {
        Object[] proxies = new Object[protocols.length];
        for (int idx = 0; idx < protocols.length; ++idx) {
            proxies[idx] = this.actorProxyFor(protocols[idx], actor, mailbox);
        }
        return proxies;
    }

    Supervisor commonSupervisorOr(Class<?> protocol, Supervisor defaultSupervisor) {
        Supervisor common = this.commonSupervisors.get(protocol);
        if (common != null) {
            return common;
        }
        return defaultSupervisor;
    }

    void handleFailureOf(Supervised supervised) {
        supervised.suspend();
        supervised.supervisor().inform(supervised.throwable(), supervised);
    }

    void startDirectoryScanner() {
        this.directoryScanner = this.actorFor(DirectoryScanner.class, Definition.has(DirectoryScannerActor.class, () -> new DirectoryScannerActor(this.directory)), this.world().addressFactory().uniqueWith("DirectoryScanner::" + this.name()));
        DirectoryEvictionConfiguration evictionConfiguration = this.world.configuration().directoryEvictionConfiguration();
        if (evictionConfiguration != null && evictionConfiguration.isEnabled()) {
            this.world.defaultLogger().debug("Scheduling directory eviction for stage: {} with: {}", this.name(), evictionConfiguration);
            Scheduled evictorActor = this.actorFor(Scheduled.class, Definition.has(DirectoryEvictor.class, () -> new DirectoryEvictor(evictionConfiguration, this.directory)), this.world().addressFactory().uniqueWith("EvictorActor::" + this.name()));
            long evictorActorInterval = Properties.getLong("stage.evictor.interval", Math.min(15000L, evictionConfiguration.lruThresholdMillis()));
            this.scheduler().schedule(evictorActor, null, evictorActorInterval, evictorActorInterval);
        }
    }

    void stop(Actor actor) {
        Actor removedActor = this.directory.remove(actor.address());
        if (actor == removedActor) {
            removedActor.lifeCycle.stop(actor);
        }
    }

    protected <T> T actorThunkFor(Class<T> protocol, Definition definition, Address address) {
        Mailbox actorMailbox = this.allocateMailbox(definition, address, null);
        ActorProtocolActor<T> actor = this.actorProtocolFor(protocol, definition, definition.parentOr(this.world.defaultParent()), address, actorMailbox, definition.supervisor(), definition.loggerOr(this.world.defaultLogger()));
        return actor.protocolActor();
    }

    protected void extenderStartDirectoryScanner() {
        this.startDirectoryScanner();
    }

    protected Address allocateAddress(Definition definition, Address maybeAddress) {
        Address address = maybeAddress != null ? maybeAddress : this.addressFactory().uniqueWith(definition.actorName());
        return address;
    }

    protected Mailbox allocateMailbox(Definition definition, Address address, Mailbox maybeMailbox) {
        Mailbox mailbox = maybeMailbox != null ? maybeMailbox : ActorFactory.actorMailbox(this, address, definition, this.mailboxWrapper());
        return mailbox;
    }

    protected Directory directory() {
        return this.directory;
    }

    protected ActorFactory.MailboxWrapper mailboxWrapper() {
        return ActorFactory.MailboxWrapper.Identity;
    }

    private void assertProtocolCompliance(Class<?> protocol) {
        if (!protocol.isInterface()) {
            throw new IllegalArgumentException("Actor protocol must be an interface not a class: " + protocol.getName());
        }
    }

    private void assertProtocolCompliance(Class<?>[] protocols) {
        for (Class<?> protocol : protocols) {
            this.assertProtocolCompliance(protocol);
        }
    }

    private Actor createRawActor(Definition definition, Actor parent, Address maybeAddress, Mailbox maybeMailbox, Supervisor maybeSupervisor, Logger logger) {
        Actor actor;
        Address address;
        if (this.isStopped()) {
            throw new IllegalStateException("Actor stage has been stopped.");
        }
        Address address2 = address = maybeAddress != null ? maybeAddress : this.addressFactory().uniqueWith(definition.actorName());
        if (this.directory.isRegistered(address)) {
            throw new Directory.ActorAddressAlreadyRegistered(definition.type(), address);
        }
        Mailbox mailbox = maybeMailbox != null ? maybeMailbox : ActorFactory.actorMailbox(this, address, definition, this.mailboxWrapper());
        try {
            actor = ActorFactory.actorFor(this, parent, definition, address, mailbox, maybeSupervisor, logger);
        }
        catch (Exception e) {
            logger.error("Actor instantiation failed because: " + e.getMessage(), e);
            throw new IllegalArgumentException("Actor instantiation failed because: " + e.getMessage(), e);
        }
        this.directory.register(actor.address(), actor);
        actor.lifeCycle.beforeStart(actor);
        return actor;
    }

    private void sweep() {
        if (this.world.privateRoot() != null) {
            this.world.privateRoot().stop();
        }
    }

    private Definition redefinitionWithMailboxName(Definition definition, String mailboxName) {
        Definition redefinition = definition.hasInstantiator() ? Definition.has(definition.type(), definition.instantiator(), mailboxName, definition.actorName()) : Definition.has(definition.type(), definition.parameters(), mailboxName, definition.actorName());
        return redefinition;
    }

    Actor rawLookupOrStart(Definition definition, Address address) {
        Actor actor = this.directory.actorOf(address);
        if (actor != null) {
            return actor;
        }
        try {
            return this.createRawActor(definition, definition.parentOr(this.world.defaultParent()), address, null, definition.supervisor(), this.world.defaultLogger());
        }
        catch (Directory.ActorAddressAlreadyRegistered ignored) {
            return this.rawLookupOrStart(definition, address);
        }
    }

    <T> T lookupOrStart(Class<T> protocol, Definition definition, Address address) {
        return this.actorAs(this.actorLookupOrStart(definition, address), protocol);
    }

    <T> Actor actorLookupOrStart(Definition definition, Address address) {
        Actor actor = this.directory.actorOf(address);
        if (actor != null) {
            return actor;
        }
        try {
            this.actorFor(Startable.class, definition, address);
            return this.directory.actorOf(address);
        }
        catch (Directory.ActorAddressAlreadyRegistered ignored) {
            return this.actorLookupOrStart(definition, address);
        }
    }

    <T> T lookupOrStartThunk(Class<T> protocol, Definition definition, Address address) {
        return this.actorAs(this.actorLookupOrStartThunk(definition, address), protocol);
    }

    Actor actorLookupOrStartThunk(Definition definition, Address address) {
        Actor actor = this.directory.actorOf(address);
        if (actor != null) {
            return actor;
        }
        try {
            this.actorThunkFor(Startable.class, definition, address);
            return this.directory.actorOf(address);
        }
        catch (Directory.ActorAddressAlreadyRegistered ignored) {
            return this.actorLookupOrStartThunk(definition, address);
        }
    }

    protected static class ActorProtocolActor<T> {
        private final Actor actor;
        private final T protocolActor;

        public static ActorProtocolActor<Object>[] allOf(Object[] protocolActors, Actor actor) {
            ActorProtocolActor[] all = new ActorProtocolActor[protocolActors.length];
            for (int idx = 0; idx < protocolActors.length; ++idx) {
                all[idx] = new ActorProtocolActor<Object>(actor, protocolActors[idx]);
            }
            return all;
        }

        public static Object[] toActors(ActorProtocolActor<Object>[] all) {
            Object[] actors = new Object[all.length];
            for (int idx = 0; idx < all.length; ++idx) {
                actors[idx] = all[idx].protocolActor();
            }
            return actors;
        }

        public static TestActor<?>[] toTestActors(ActorProtocolActor<Object>[] all) {
            TestActor[] testActors = new TestActor[all.length];
            for (int idx = 0; idx < all.length; ++idx) {
                testActors[idx] = all[idx].toTestActor();
            }
            return testActors;
        }

        public ActorProtocolActor(Actor actor, T protocol) {
            this.actor = actor;
            this.protocolActor = protocol;
        }

        public T protocolActor() {
            return this.protocolActor;
        }

        public TestActor<T> toTestActor() {
            return new TestActor<T>(this.actor, this.protocolActor, this.actor.address());
        }
    }
}

