/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.ActorInstantiator;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.AddressFactory;
import io.vlingo.xoom.actors.BasicAddressFactory;
import io.vlingo.xoom.actors.CompletesEventually;
import io.vlingo.xoom.actors.CompletesEventuallyProvider;
import io.vlingo.xoom.actors.CompletesEventuallyProviderKeeper;
import io.vlingo.xoom.actors.Configuration;
import io.vlingo.xoom.actors.DeadLetters;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.Logger;
import io.vlingo.xoom.actors.LoggerProvider;
import io.vlingo.xoom.actors.LoggerProviderKeeper;
import io.vlingo.xoom.actors.Logger__Proxy;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.MailboxProvider;
import io.vlingo.xoom.actors.MailboxProviderKeeper;
import io.vlingo.xoom.actors.PrivateRootActor;
import io.vlingo.xoom.actors.Properties;
import io.vlingo.xoom.actors.Protocols;
import io.vlingo.xoom.actors.Registrar;
import io.vlingo.xoom.actors.Returns;
import io.vlingo.xoom.actors.Stage;
import io.vlingo.xoom.actors.Stoppable;
import io.vlingo.xoom.actors.Supervisor;
import io.vlingo.xoom.actors.plugin.completes.DefaultCompletesEventuallyProviderKeeper;
import io.vlingo.xoom.actors.plugin.logging.DefaultLoggerProviderKeeper;
import io.vlingo.xoom.actors.plugin.mailbox.DefaultMailboxProviderKeeper;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class World
implements Registrar {
    static final long PRIVATE_ROOT_ID = Long.MAX_VALUE;
    static final String PRIVATE_ROOT_NAME = "#private";
    static final long PUBLIC_ROOT_ID = 0x7FFFFFFFFFFFFFFEL;
    static final String PUBLIC_ROOT_NAME = "#public";
    static final long DEADLETTERS_ID = 0x7FFFFFFFFFFFFFFDL;
    static final String DEADLETTERS_NAME = "#deadLetters";
    public static final long HIGH_ROOT_ID = 0x7FFFFFFFFFFFFFFCL;
    static final String DEFAULT_STAGE = "__defaultStage";
    private final AddressFactory addressFactory;
    private final Configuration configuration;
    private final String name;
    private final Map<String, Stage> stages;
    private final Map<String, Object> dynamicDependencies;
    private ClassLoader classLoader;
    private CompletesEventuallyProviderKeeper completesProviderKeeper;
    private DeadLetters deadLetters;
    private Logger defaultLogger;
    private Actor defaultParent;
    private Supervisor defaultSupervisor;
    private LoggerProviderKeeper loggerProviderKeeper;
    private MailboxProviderKeeper mailboxProviderKeeper;
    private Stoppable privateRoot;
    private Stoppable publicRoot;

    public static World start(String name) {
        return World.start(name, Properties.properties);
    }

    public static World start(String name, java.util.Properties properties) {
        return World.start(name, Configuration.defineWith(properties));
    }

    public static World start(String name, Configuration configuration) {
        if (name == null) {
            throw new IllegalArgumentException("The world name must not be null.");
        }
        return new World(name, configuration);
    }

    public static World startWithDefaults(String name) {
        return World.start(name, Configuration.define());
    }

    public <T, A extends Actor> T actorFor(Class<T> protocol, Class<? extends Actor> type, ActorInstantiator<A> instantiator) {
        if (this.isTerminated()) {
            throw new IllegalStateException("XOOM: Stopped.");
        }
        return this.stage().actorFor(protocol, type, instantiator);
    }

    public <T> T actorFor(Class<T> protocol, Class<? extends Actor> type, Object ... parameters) {
        if (this.isTerminated()) {
            throw new IllegalStateException("XOOM: Stopped.");
        }
        return this.stage().actorFor(protocol, type, parameters);
    }

    public <T> T actorFor(Class<T> protocol, Definition definition) {
        if (this.isTerminated()) {
            throw new IllegalStateException("XOOM: Stopped.");
        }
        return this.stage().actorFor(protocol, definition);
    }

    public Protocols actorFor(Class<?>[] protocols, Class<? extends Actor> type, Object ... parameters) {
        if (this.isTerminated()) {
            throw new IllegalStateException("XOOM: Stopped.");
        }
        return this.stage().actorFor(protocols, type, parameters);
    }

    public Protocols actorFor(Class<?>[] protocols, Definition definition) {
        if (this.isTerminated()) {
            throw new IllegalStateException("XOOM: Stopped.");
        }
        return this.stage().actorFor(protocols, definition);
    }

    public AddressFactory addressFactory() {
        return this.addressFactory;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public DeadLetters deadLetters() {
        return this.deadLetters;
    }

    public <T> CompletesEventually completesFor(Returns<T> clientReturns) {
        return this.completesProviderKeeper.findDefault().provideCompletesFor(clientReturns);
    }

    public CompletesEventually completesFor(Address address, Returns<Object> clientReturns) {
        return this.completesProviderKeeper.findDefault().provideCompletesFor(address, clientReturns);
    }

    public Logger defaultLogger() {
        if (this.defaultLogger != null) {
            return this.defaultLogger;
        }
        if (this.loggerProviderKeeper != null) {
            LoggerProvider maybeLoggerProvider = this.loggerProviderKeeper.findDefault();
            Logger logger = this.defaultLogger = maybeLoggerProvider != null ? maybeLoggerProvider.logger() : LoggerProvider.noOpLoggerProvider().logger();
        }
        if (this.defaultLogger == null) {
            this.defaultLogger = LoggerProvider.standardLoggerProvider(this, "vlingo").logger();
        }
        return this.defaultLogger;
    }

    public Actor defaultParent() {
        return this.defaultParent;
    }

    public Supervisor defaultSupervisor() {
        if (this.defaultSupervisor == null) {
            this.defaultSupervisor = this.defaultParent().selfAs(Supervisor.class);
        }
        return this.defaultSupervisor;
    }

    public Logger logger(String name) {
        return this.loggerProviderKeeper.findNamed(name).logger();
    }

    public String name() {
        return this.name;
    }

    @Override
    public void register(String name, CompletesEventuallyProvider completesEventuallyProvider) {
        completesEventuallyProvider.initializeUsing(this.stage());
        this.completesProviderKeeper.keep(name, completesEventuallyProvider);
    }

    @Override
    public void register(String name, boolean isDefault, LoggerProvider loggerProvider) {
        boolean actualDefault = this.loggerProviderKeeper.findDefault() == null ? true : isDefault;
        this.loggerProviderKeeper.keep(name, actualDefault, loggerProvider);
        this.defaultLogger = this.loggerProviderKeeper.findDefault().logger();
    }

    @Override
    public void register(String name, boolean isDefault, MailboxProvider mailboxProvider) {
        this.mailboxProviderKeeper.keep(name, isDefault, mailboxProvider);
    }

    @Override
    public void registerCommonSupervisor(String stageName, String name, Class<?> supervisedProtocol, Class<? extends Actor> supervisorClass) {
        try {
            String actualStageName = stageName.equals("default") ? DEFAULT_STAGE : stageName;
            Stage stage = this.stageNamed(actualStageName);
            Supervisor common = stage.actorFor(Supervisor.class, Definition.has(supervisorClass, Definition.NoParameters, name));
            stage.registerCommonSupervisor(supervisedProtocol, common);
        }
        catch (Exception e) {
            this.defaultLogger().error("XOOM: World cannot register common supervisor: " + supervisedProtocol.getName(), e);
        }
    }

    @Override
    public void registerDefaultSupervisor(String stageName, String name, Class<? extends Actor> supervisorClass) {
        try {
            String actualStageName = stageName.equals("default") ? DEFAULT_STAGE : stageName;
            Stage stage = this.stageNamed(actualStageName);
            this.defaultSupervisor = stage.actorFor(Supervisor.class, Definition.has(supervisorClass, Definition.NoParameters, name));
        }
        catch (Exception e) {
            this.defaultLogger().error("XOOM: World cannot register default supervisor override: " + supervisorClass.getName(), e);
        }
    }

    @Override
    public void registerCompletesEventuallyProviderKeeper(CompletesEventuallyProviderKeeper keeper) {
        if (this.completesProviderKeeper != null) {
            this.completesProviderKeeper.close();
        }
        this.completesProviderKeeper = keeper;
    }

    @Override
    public void registerLoggerProviderKeeper(LoggerProviderKeeper keeper) {
        if (this.loggerProviderKeeper != null) {
            this.loggerProviderKeeper.close();
        }
        this.loggerProviderKeeper = keeper;
    }

    @Override
    public void registerMailboxProviderKeeper(MailboxProviderKeeper keeper) {
        if (this.mailboxProviderKeeper != null) {
            this.mailboxProviderKeeper.close();
        }
        this.mailboxProviderKeeper = keeper;
    }

    public void registerDynamic(String name, Object value) {
        this.dynamicDependencies.putIfAbsent(name, value);
    }

    public <DEPENDENCY> DEPENDENCY resolveDynamic(String name, Class<DEPENDENCY> anyDependencyClass) {
        return anyDependencyClass.cast(this.dynamicDependencies.get(name));
    }

    public Stage stage() {
        return this.stageNamed(DEFAULT_STAGE);
    }

    public Stage stageNamed(String name) {
        return this.stageNamed(name, Stage.class, this.addressFactory);
    }

    public synchronized Stage stageNamed(String name, Class<? extends Stage> stageType, AddressFactory addressFactory) {
        Stage stage = this.stages.get(name);
        if (stage == null) {
            try {
                if (stageType == Stage.class) {
                    stage = new Stage(this, addressFactory, name);
                } else {
                    Constructor<? extends Stage> ctor = stageType.getConstructor(World.class, AddressFactory.class, String.class);
                    stage = ctor.newInstance(this, addressFactory, name);
                }
                if (!name.equals(DEFAULT_STAGE)) {
                    stage.startDirectoryScanner();
                }
                this.stages.put(name, stage);
            }
            catch (Exception e) {
                String message = "World cannot create new stage: " + name + " because: " + e.getMessage();
                this.defaultLogger().error(message, e);
                throw new IllegalStateException(message, e);
            }
        }
        return stage;
    }

    public boolean isTerminated() {
        return this.stage().isStopped();
    }

    public void terminate() {
        if (!this.isTerminated()) {
            this.syncFlushLogger();
            for (Stage stage : this.stages.values()) {
                stage.stop();
            }
            this.loggerProviderKeeper.close();
            this.mailboxProviderKeeper.close();
            this.completesProviderKeeper.close();
        }
    }

    @Override
    public World world() {
        return this;
    }

    Mailbox assignMailbox(String mailboxName, int hashCode) {
        return this.mailboxProviderKeeper.assignMailbox(mailboxName, hashCode);
    }

    <L extends ClassLoader> L classLoader() {
        return (L)this.classLoader;
    }

    <L extends ClassLoader> void classLoader(L classLoader) {
        this.classLoader = classLoader;
    }

    String mailboxNameFrom(String candidateMailboxName) {
        if (candidateMailboxName == null) {
            return this.findDefaultMailboxName();
        }
        if (this.mailboxProviderKeeper.isValidMailboxName(candidateMailboxName)) {
            return candidateMailboxName;
        }
        return this.findDefaultMailboxName();
    }

    String findDefaultMailboxName() {
        return this.mailboxProviderKeeper.findDefault();
    }

    synchronized void setDefaultParent(Actor defaultParent) {
        if (defaultParent != null && this.defaultParent != null) {
            throw new IllegalStateException("Default parent already exists.");
        }
        this.defaultParent = defaultParent;
    }

    synchronized void setDeadLetters(DeadLetters deadLetters) {
        if (deadLetters != null && this.deadLetters != null) {
            deadLetters.stop();
            throw new IllegalStateException("Dead letters already exists.");
        }
        this.deadLetters = deadLetters;
    }

    Stoppable privateRoot() {
        return this.privateRoot;
    }

    synchronized void setPrivateRoot(Stoppable privateRoot) {
        if (privateRoot != null && this.privateRoot != null) {
            privateRoot.stop();
            throw new IllegalStateException("Private root already exists.");
        }
        this.privateRoot = privateRoot;
    }

    Stoppable publicRoot() {
        return this.publicRoot;
    }

    synchronized void setPublicRoot(Stoppable publicRoot) {
        if (publicRoot != null && this.publicRoot != null) {
            throw new IllegalStateException("The public root already exists.");
        }
        this.publicRoot = publicRoot;
    }

    private World(String name, Configuration configuration) {
        this.name = name;
        this.configuration = configuration;
        this.addressFactory = configuration.addressFactoryOr(BasicAddressFactory::new);
        this.completesProviderKeeper = new DefaultCompletesEventuallyProviderKeeper();
        this.loggerProviderKeeper = new DefaultLoggerProviderKeeper();
        this.mailboxProviderKeeper = new DefaultMailboxProviderKeeper();
        this.stages = new ConcurrentHashMap<String, Stage>();
        this.dynamicDependencies = new ConcurrentHashMap<String, Object>();
        Stage defaultStage = this.stageNamed(DEFAULT_STAGE);
        configuration.startPlugins(this, 0);
        configuration.startPlugins(this, 1);
        this.startRootFor(defaultStage, this.defaultLogger());
        configuration.startPlugins(this, 2);
        defaultStage.startDirectoryScanner();
    }

    private void startRootFor(Stage stage, Logger logger) {
        stage.actorProtocolFor(Stoppable.class, Definition.has(PrivateRootActor.class, PrivateRootActor::new, PRIVATE_ROOT_NAME), null, this.addressFactory.from(Long.MAX_VALUE, PRIVATE_ROOT_NAME), null, null, logger);
    }

    private void syncFlushLogger() {
        try {
            ((Logger__Proxy)this.defaultLogger()).flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

