/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.logging;

import io.vlingo.xoom.actors.Address;
import java.time.Instant;
import java.util.Optional;

public class LogEvent {
    private final Class<?> source;
    private final String message;
    private final Object[] args;
    private final Throwable throwable;
    private final String sourceThread;
    private final Instant eventTimestamp;
    private final Address sourceActorAddress;

    public LogEvent(Class<?> source, String sourceThread, Instant eventTimestamp, String message, Object[] args, Throwable throwable, Address sourceActorAddress) {
        this.source = source;
        this.message = message;
        this.args = args;
        this.throwable = throwable;
        this.sourceThread = sourceThread;
        this.eventTimestamp = eventTimestamp;
        this.sourceActorAddress = sourceActorAddress;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Optional<String> getSourceThread() {
        return Optional.ofNullable(this.sourceThread);
    }

    public Optional<Instant> getEventTimestamp() {
        return Optional.ofNullable(this.eventTimestamp);
    }

    public Optional<Address> getSourceActorAddress() {
        return Optional.ofNullable(this.sourceActorAddress);
    }

    public static class Builder {
        private final Class<?> source;
        private final String message;
        private final String sourceThread;
        private final Instant eventTimestamp;
        private Object[] args;
        private Throwable throwable;
        private Address sourceActorAddress;

        public Builder(Class<?> source, String message, String sourceThread, Instant eventTimestamp) {
            this.source = source;
            this.message = message;
            this.sourceThread = sourceThread;
            this.eventTimestamp = eventTimestamp;
        }

        public Builder(Class<?> source, String message) {
            this.source = source;
            this.message = message;
            this.sourceThread = Thread.currentThread().getName();
            this.eventTimestamp = Instant.now();
        }

        public Builder withArgs(Object ... args) {
            this.args = args;
            return this;
        }

        public Builder withThrowable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public Builder withSourceActorAddress(Address sourceActorAddress) {
            this.sourceActorAddress = sourceActorAddress;
            return this;
        }

        public LogEvent build() {
            return new LogEvent(this.source, this.sourceThread, this.eventTimestamp, this.message, this.args, this.throwable, this.sourceActorAddress);
        }
    }
}

