/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.completes;

import io.vlingo.xoom.actors.CompletesEventuallyProvider;
import io.vlingo.xoom.actors.Configuration;
import io.vlingo.xoom.actors.Registrar;
import io.vlingo.xoom.actors.plugin.AbstractPlugin;
import io.vlingo.xoom.actors.plugin.Plugin;
import io.vlingo.xoom.actors.plugin.PluginConfiguration;
import io.vlingo.xoom.actors.plugin.PluginProperties;
import io.vlingo.xoom.actors.plugin.completes.CompletesEventuallyPool;
import java.util.Properties;

public class PooledCompletesPlugin
extends AbstractPlugin
implements Plugin {
    private CompletesEventuallyProvider completesEventuallyProvider;
    private final PooledCompletesPluginConfiguration pooledCompletesPluginConfiguration;

    public PooledCompletesPlugin() {
        this.pooledCompletesPluginConfiguration = PooledCompletesPluginConfiguration.define();
    }

    @Override
    public void close() {
        this.completesEventuallyProvider.close();
    }

    @Override
    public PluginConfiguration configuration() {
        return this.pooledCompletesPluginConfiguration;
    }

    @Override
    public String name() {
        return this.pooledCompletesPluginConfiguration.name();
    }

    @Override
    public int pass() {
        return 2;
    }

    @Override
    public void start(Registrar registrar) {
        this.completesEventuallyProvider = new CompletesEventuallyPool(this.pooledCompletesPluginConfiguration.poolSize, this.pooledCompletesPluginConfiguration.mailbox);
        registrar.register(this.pooledCompletesPluginConfiguration.name(), this.completesEventuallyProvider);
    }

    @Override
    public Plugin with(PluginConfiguration overrideConfiguration) {
        if (overrideConfiguration == null) {
            return this;
        }
        return new PooledCompletesPlugin(overrideConfiguration);
    }

    @Override
    public void __internal_Only_Init(String name, Configuration configuration, Properties properties) {
        this.pooledCompletesPluginConfiguration.name = name;
    }

    private PooledCompletesPlugin(PluginConfiguration configuration) {
        this.pooledCompletesPluginConfiguration = (PooledCompletesPluginConfiguration)configuration;
    }

    public static class PooledCompletesPluginConfiguration
    implements PluginConfiguration {
        private String mailbox;
        private String name = "pooledCompletes";
        private int poolSize;

        public static PooledCompletesPluginConfiguration define() {
            return new PooledCompletesPluginConfiguration();
        }

        public PooledCompletesPluginConfiguration mailbox(String mailbox) {
            this.mailbox = mailbox;
            return this;
        }

        public String mailbox() {
            return this.mailbox;
        }

        public PooledCompletesPluginConfiguration poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public int poolSize() {
            return this.poolSize;
        }

        @Override
        public void build(Configuration configuration) {
            configuration.with(this.mailbox("queueMailbox").poolSize(10));
        }

        @Override
        public void buildWith(Configuration configuration, PluginProperties properties) {
            this.name = properties.name;
            this.poolSize = properties.getInteger("pool", 10);
            this.mailbox = properties.getString("mailbox", null);
            configuration.with(this);
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

