/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox;

import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.MailboxProvider;
import io.vlingo.xoom.actors.MailboxProviderKeeper;
import java.util.HashMap;
import java.util.Map;

public final class DefaultMailboxProviderKeeper
implements MailboxProviderKeeper {
    private final Map<String, MailboxProviderInfo> mailboxProviderInfos = new HashMap<String, MailboxProviderInfo>();
    private MailboxProviderInfo defaultProvider = null;

    @Override
    public Mailbox assignMailbox(String name, int hashCode) {
        MailboxProviderInfo info = this.mailboxProviderInfos.get(name);
        if (info == null) {
            throw new IllegalStateException("No registered MailboxProvider named " + name);
        }
        return info.mailboxProvider.provideMailboxFor(hashCode);
    }

    @Override
    public void close() {
        this.mailboxProviderInfos.values().forEach(info -> info.mailboxProvider.close());
    }

    @Override
    public String findDefault() {
        if (this.defaultProvider == null) {
            throw new IllegalStateException("No registered default MailboxProvider.");
        }
        return this.defaultProvider.name;
    }

    @Override
    public void keep(String name, boolean isDefault, MailboxProvider mailboxProvider) {
        MailboxProviderInfo providerInfo = new MailboxProviderInfo(name, mailboxProvider);
        this.mailboxProviderInfos.put(name, providerInfo);
        if (this.defaultProvider == null || isDefault) {
            this.defaultProvider = providerInfo;
        }
    }

    @Override
    public boolean isValidMailboxName(String candidateMailboxName) {
        return this.mailboxProviderInfos.containsKey(candidateMailboxName);
    }

    private static final class MailboxProviderInfo {
        final MailboxProvider mailboxProvider;
        final String name;

        MailboxProviderInfo(String name, MailboxProvider mailboxProvider) {
            this.name = name;
            this.mailboxProvider = mailboxProvider;
        }
    }
}

