/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.agronampscarrayqueue;

import io.vlingo.xoom.actors.Backoff;
import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.plugin.mailbox.agronampscarrayqueue.ManyToOneConcurrentArrayQueueMailbox;
import java.util.concurrent.atomic.AtomicBoolean;

public class ManyToOneConcurrentArrayQueueDispatcher
extends Thread
implements Dispatcher {
    private final Backoff backoff;
    private final Mailbox mailbox;
    private final boolean requiresExecutionNotification;
    private final int throttlingCount;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    protected ManyToOneConcurrentArrayQueueDispatcher(int mailboxSize, long fixedBackoff, boolean notifyOnSend, int throttlingCount, int totalSendRetries) {
        this.backoff = fixedBackoff == 0L ? null : new Backoff(fixedBackoff);
        this.requiresExecutionNotification = fixedBackoff == 0L;
        this.mailbox = new ManyToOneConcurrentArrayQueueMailbox(this, mailboxSize, totalSendRetries, notifyOnSend);
        this.throttlingCount = throttlingCount;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public int concurrencyCapacity() {
        return 1;
    }

    @Override
    public void execute(Mailbox mailbox) {
        this.interrupt();
    }

    @Override
    public boolean requiresExecutionNotification() {
        return this.requiresExecutionNotification;
    }

    @Override
    public void run() {
        while (!this.closed.get()) {
            if (this.deliver() || this.backoff == null) continue;
            this.backoff.now();
        }
    }

    protected Mailbox mailbox() {
        return this.mailbox;
    }

    private boolean deliver() {
        for (int idx = 0; idx < this.throttlingCount; ++idx) {
            Message message = this.mailbox.receive();
            if (message == null) {
                return idx > 0;
            }
            message.deliver();
        }
        return true;
    }
}

